<?php

namespace App\Http\Controllers;

use DB;
use Illuminate\Http\Request;

class FrontendCommentController extends Controller
{

    public function __construct()
    {
        //
    }

    /** Show */
    public function store(Request $request)
    {

        $this->validate($request, [
            'content_id' => 'required',
            'name' => 'required',
            'title' => 'required',
            'email' => 'required|email',
            'comment' => 'required',
            'type' => 'required',
            'user_rating' => 'nullable',
        ]);

        $client_ip = $request->ip();

        if (isset(request()->user_rating)) {
            $rating = request()->user_rating;
        } else {
            $rating = 0;
        }

        DB::table('comments')->insert(
            [
                'content_id' => request()->content_id,
                'name' => request()->name,
                'title' => request()->title,
                'email' => request()->email,
                'comment' => request()->comment,
                'type' => request()->type,
                'rating' => $rating,
                'approval' => 0,
                'ip' => $client_ip,
                'created_at' => \Carbon\Carbon::now()->toDateTimeString(),
            ]
        );

        return '<div class="alert alert-success mt-3 mb-0 show" role="alert">' . __('general.comment_thanks') . '</div>';
    }

}
