<?php

namespace App\Http\Controllers;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Intervention\Image\ImageManagerStatic as Image;

class MultipleUploadController extends Controller
{
     public function __construct()
    {
         $this->middleware('auth');

        // Site Settings
        $site_settings = DB::table('settings')->get();

        foreach ($site_settings as $setting) {
            $setting_name = $setting->name;
            $this->$setting_name = $setting->value;
        }
    }

    /** Index */
    public function index()
    {
        return view('adminlte::multiple_file_upload');
    }

    /** Delete */
    public function delete(Request $request)
    {

        if (!empty($request->image_name)) {
            if (file_exists(public_path() . '/images/uploads/' . $request->image_name)) {
                unlink(public_path() . '/images/uploads/' . $request->image_name);
            }
        }

        $screenshot_query = DB::table('links')->where('id', '=', $request->link_id)->pluck('gallery');

        $screenshot_query = explode(',', $screenshot_query[0]);

        $screenshots = array_diff($screenshot_query, array($request->image_name));

        $comma_separated = implode(",", $screenshots);
        DB::table('links')->where('id', $request->link_id)->update(array('gallery' => $comma_separated));

        // Clear cache
        Cache::flush();
    }

    /** Upload */
    public function upload(Request $request)
    {

        $this->validate($request, [
            'file' => 'required',
            'file.*' => 'image',
        ]);

        $image_code = '';
        $images = $request->file('file');
        foreach ($images as $image) {
            if ($this->save_as_webp == '1') {
                $new_name = time() . rand(1111111,9999999) . '.webp';
            } else {
                $new_name = time() . '.' . $image->getClientOriginalExtension();
            }
            $location = public_path('images/uploads/' . $new_name);
            Image::make($image)->heighten(400)->save($location, $this->image_quality);
            $image_code .= "$new_name,";
            $sql_query = "UPDATE links set gallery = IF(`gallery` = '','$new_name',CONCAT(gallery, ',', '$new_name')) WHERE find_in_set('$new_name',gallery) = 0 AND id = $request->link_id";
            $result = DB::update($sql_query);
        }

        $screenshot_query = DB::table('links')->where('id', '=', $request->link_id)->pluck('gallery');

        $mysplit = explode(',', $screenshot_query[0]);
        $screenshot_data = array_reverse($mysplit);

        $image_code_s = '';
        foreach ($screenshot_data as $screenshot) {
            $image_code_s .= '<div class="col-md-2 mb-10 text-center"><img src="/images/uploads/' . $screenshot . '" class="img-thumbnail" /><button type="button" data-name="' . $screenshot . '" data-link-id="' . $request->link_id . '" class="btn btn-danger mt-10 remove_gallery">Delete</button></div>';
        }

        $output = array(
            'success' => __('admin.images_uploaded'),
            'image' => $image_code_s,
        );

        // Clear cache
        Cache::flush();

        return response()->json($output);
    }

}
