<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class Passwordreset extends Mailable
{
    use Queueable, SerializesModels;
    
    public $link;
    public $site_title;
    public $mail_from;
    
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($link, $site_title, $mail_from)
    {
        $this->link = $link;
        $this->mail_from = $mail_from;
        $this->site_title = $site_title;
        }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from($this->mail_from)->markdown('vendor.frontend.mail.passwordreset')->subject(__('general.reset_your_password'));
    }
}
