<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class Sendemail extends Mailable
{
    use Queueable, SerializesModels;

    public $email_subject;
    public $email_body;
    public $site_title;
    public $mail_from;

    /**
     * Create a new message instance.
     *
     * @return void
     */
     public function __construct($email_subject, $email_body, $site_title, $mail_from)
    {
        $this->email_subject = $email_subject;
        $this->email_body = $email_body;
        $this->mail_from = $mail_from;
        $this->site_title = $site_title;

        }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from($this->mail_from)->markdown('vendor.frontend.mail.send_email')->subject($this->email_subject);
    }
}
