<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;

class Location extends Model
{
    public function children()
    {
        return $this->hasMany('App\Models\Location', 'parent_id')->orderBy('title');
    }

    public function home_categories() {
        return $this->children()->where('home_page','=', 1);
    }

    use Sluggable;

    /**
     * Return the sluggable configuration array for this model.
     *
     * @return array
     */
    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }
    protected $fillable = [
        'title',
        'custom_title',
        'custom_description',
        'image',
        'slug',
        'parent_id',
    ];
}