<?php

namespace App\Models;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;

class Submission extends Model
{
    use Sluggable;

    /**
     * Return the sluggable configuration array for this model.
     *
     * @return array
     */
    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'title',
            ],
        ];
    }

    protected $fillable = [
        'title',
        'description',
        'image',
        'slug',
        'url',
        'visible_url',
        'bypass_redirect',
        'bypass_type',
        'deep_links',
        'page_views',
        'clicks',
        'category',
        'featured_category',
        'featured_home',
    ];
}