@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.create_link'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- form -->
            <form method="POST" enctype="multipart/form-data" action="{{url(env('ADMIN_URL').'/links')}}">
                @csrf @method('POST')

                <!-- box-body -->
                <div class="box-body">

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('admin.url') <span class="text-danger">*</span></label>
                                <input type="text" name="url" id="url" class="form-control" value="{{old('url')}}" placeholder="@lang('admin.url')" />
                                <button onclick="get_details()" type="button" class="btn btn-primary btn-sm mt-5">@lang('admin.retrieve_details')</button>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('admin.slug')</label>
                                <input type="text" name="slug" class="form-control" value="{{old('slug')}}" placeholder="@lang('admin.slug')" />
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <div class="form-group">
                        <label>@lang('admin.title') <span class="text-danger">*</span></label>
                        <input type="text" name="title" id="title" class="form-control" value="{{old('title')}}" placeholder="@lang('admin.title')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.visible_url')</label>
                        <input type="text" name="visible_url" class="form-control" value="{{old('visible_url')}}" placeholder="@lang('admin.visible_url')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.description') <span class="text-danger">*</span></label>
                        <textarea class="form-control" name="description" id="description" rows="3" placeholder="@lang('admin.description')">{{old('description')}}</textarea>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.tags')</label>
                        <input type="text" name="tags" id="tags" class="form-control" data-role="tagsinput" placeholder="@lang('admin.tags')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.phone_number')</label>
                        <input type="text" name="phone_number" id="phone_number" class="form-control" value="{{old('phone_number')}}" placeholder="@lang('admin.phone_number')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.email')</label>
                        <input type="text" name="email" id="email" class="form-control" value="{{old('email')}}" placeholder="@lang('admin.email')" />
                    </div>

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">

                            <div class="form-group">
                                <label>@lang('admin.address')</label>
                                <textarea class="form-control" name="address" id="address" rows="3" placeholder="@lang('admin.address')">{{old('address')}}</textarea>
                            </div>

                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.category') <span class="text-danger">*</span></label>
                                <select title="@lang('admin.select_category')" name="categories[]" class="form-control selectpicker" id="multi-categories" multiple="multiple" data-live-search="true" required="required">
                                    @foreach($categories as $category)
                                    <option class="category-head" value="{{ $category->id }}" data-lang="{{ $category->language }}" data-content="[{{$array_data['language_code'][$category->language]}}] {{$category->title}}" {{ old('category') == $category->id ? 'selected' : '' }}></option>

                                    @foreach($category->children as $submenu)
                                    <option class="sub-category-head" value="{{ $submenu->id }}" data-lang="{{ $submenu->language }}" data-content="{{$submenu->title}}" {{ old('category') == $submenu->id ? 'selected' : '' }}></option>

                                    @endforeach

                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <script>
                        $('#multi-categories').on('changed.bs.select', function(e) {
                            var value = $('option:selected', this).attr('data-lang');

                            var selectedOptions = jQuery('#multi-categories option:selected');

                            if (selectedOptions.length > 0) {
                                $("#multi-categories [data-lang!='" + value + "']").attr("disabled", "true");
                                $('#multi-categories').selectpicker('refresh');
                            } else {
                                $("#multi-categories [data-lang!='" + value + "']").removeAttr("disabled", "true");
                                $('#multi-categories').selectpicker('refresh');
                            }
                        });
                        </script>

                        <div class="col-md-4">

                            <div class="form-group">
                                <label>@lang('admin.city_country')</label>
                                <select title="@lang('admin.select_location')" name="locations" class="form-control selectpicker" id="locations" data-live-search="true">
                                    @foreach($locations as $location)
                                    <option class="category-head" value="{{ $location->id }}" data-content="[{{$array_data['language_code'][$location->language]}}] {{$location->title}}" {{ old('locations') == $location->id ? 'selected' : '' }}></option>

                                    @foreach($location->children as $submenu)
                                    <option class="sub-category-head" value="{{ $submenu->id }}" data-content="{{$submenu->title}}" {{ old('locations') == $submenu->id ? 'selected' : '' }}></option>

                                    @endforeach

                                    @endforeach
                                </select>
                            </div>

                        </div>

                    </div>
                    <!-- /.row -->

                    <script>
                    // Openlayers Map Functions
                    $(document).ready(function() {
                        "use strict";

                        if (document.getElementById("map")) {

                            var map_data = document.getElementById("map");
                            var map_lat = parseFloat(map_data.getAttribute("data-lat"));
                            var map_lon = parseFloat(map_data.getAttribute("data-lon"));
                            var map_zoom = parseFloat(map_data.getAttribute("data-zoom"));

                            var attribution = new ol.control.Attribution({
                                collapsible: false
                            });

                            var map = new ol.Map({
                                controls: ol.control.defaults({
                                    attribution: false
                                }).extend([attribution]),
                                layers: [
                                    new ol.layer.Tile({
                                        source: new ol.source.OSM({
                                            url: 'https://tile.openstreetmap.org/{z}/{x}/{y}.png',
                                            maxZoom: 18
                                        })
                                    })
                                ],
                                target: 'map',
                                view: new ol.View({
                                    center: ol.proj.fromLonLat([map_lon, map_lat]),
                                    maxZoom: 18,
                                    zoom: map_zoom,
                                })
                            });

                            var layer = new ol.layer.Vector({
                                source: new ol.source.Vector({
                                    features: [
                                        new ol.Feature({
                                            geometry: new ol.geom.Point(ol.proj.fromLonLat([map_lon, map_lat]))
                                        })
                                    ]
                                })
                            });

                            layer.set('name', 'map_marker');
                            map.addLayer(layer);

                            map.on('click', e => {
                                var point = map.getCoordinateFromPixel(e.pixel);
                                var lonLat = ol.proj.toLonLat(point);
                                var zoom = map.getView().getZoom();

                                var layer = new ol.layer.Vector({
                                    source: new ol.source.Vector({
                                        features: [
                                            new ol.Feature({
                                                geometry: new ol.geom.Point(ol.proj.fromLonLat([lonLat[0], lonLat[1]]))
                                            })
                                        ]
                                    })
                                });

                                map.getLayers().forEach(layer => {
                                    if (layer.get('name') && layer.get('name') == 'map_marker') {
                                        map.removeLayer(layer)
                                    }
                                });

                                layer.set('name', 'map_marker');
                                map.addLayer(layer);

                                $('#map_lon').val(lonLat[0]);
                                $('#map_lat').val(lonLat[1]);
                                $('#map_zoom').val(zoom);
                            })


                        }
                    });
                    </script>

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">

                            <div id="popup" class="shadow map-corner">
                                <div id="popup-content"></div>
                            </div>
                            <div id="map" data-lat="{{old('map_lat') ?? '43'}}" data-lon="{{old('mal_lon') ?? '23'}}" data-zoom="{{old('map_zoom') ?? '4'}}"></div>

                            <div class="row mt-3 mt-10">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>@lang('admin.map_lat')</label>
                                        <input type="text" name="map_lat" id="map_lat" class="form-control" value="{{old('map_lat')}}" placeholder="@lang('admin.map_lat')" />
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>@lang('admin.map_lon')</label>
                                        <input type="text" name="map_lon" id="map_lon" class="form-control" value="{{old('map_lon')}}" placeholder="@lang('admin.map_lon')" />
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>@lang('admin.map_zoom')</label>
                                        <input type="text" name="map_zoom" id="map_zoom" class="form-control" value="{{old('map_zoom')}}" placeholder="@lang('admin.map_zoom')" />
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.page_views') <span class="text-danger">*</span></label>
                                <input type="text" name="page_views" class="form-control" value="{{old('page_views') ?? 0}}" placeholder="@lang('admin.page_views')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.clicks') <span class="text-danger">*</span></label>
                                <input type="text" name="clicks" class="form-control" value="{{old('clicks') ?? 0}}" placeholder="@lang('admin.clicks')" />
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.featured_category')</label><br />
                                <input type="checkbox" name="featured_category" {{ old('featured_category') == "on" ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.featured_home')</label><br />
                                <input type="checkbox" name="featured_home" {{ old('featured_home') == "on" ? 'checked' : '' }}>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <div class="form-group">
                        <label>@lang('admin.hidden_content')</label>
                        <textarea class="textarea textarea-style" name="hidden_content" placeholder="@lang('admin.hidden_content')">{{old('hidden_content')}}</textarea>
                    </div>

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.images')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <a href="{{ asset('images/links') }}/no_image.png" data-toggle="lightbox"><img src="{{ asset('images/links') }}/no_image.png" class="img-responsive site-icon"></a>
                                <label>@lang('admin.site_icon')</label><br />
                                <label class="btn btn-outline btn-sm" id="browse-color-image">@lang('admin.browse')<input type="file" name="image" id="import-file-select" class="hidden"></label>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.screenshot')</label><br />
                                <label class="btn btn-outline btn-sm" id="browse-color-screenshot">@lang('admin.browse')<input type="file" name="screenshot" id="import-file-select" class="hidden"></label>
                            </div>
                        </div>


                    </div>
                    <!-- /.row -->

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.bypass_redirection_page')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.active')</label><br />
                                <input type="checkbox" name="bypass_redirect" id="bypass_redirect" {{ old('bypass_redirect') == "on" ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.link_type')</label>
                                <select title="@lang('admin.link_type')" name="bypass_type" id="bypass_type" class="form-control selectpicker" data-live-search="true">
                                    @foreach($link_types as $link_id => $bypass_type)
                                    <option value="{{ $link_id }}" {{ old('bypass_type') == $link_id ? 'selected' : '' }}>
                                        {{ $bypass_type }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.bypass_details_page')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.active')</label><br />
                                <input type="checkbox" name="bypass_details" id="bypass_details" {{ old('bypass_details') == "on" ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.link_type')</label>
                                <select title="@lang('admin.link_type')" name="bypass_details_type" id="bypass_details_type" class="form-control selectpicker" data-live-search="true">
                                    @foreach($link_types as $link_id => $bypass_details_type)
                                    <option value="{{ $link_id }}" {{ old('bypass_details_type') == $link_id ? 'selected' : '' }}>
                                        {{ $bypass_details_type }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.deep_links')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    @for ($i = 1; $i <= $settings['max_deep_links']; $i++) <!-- row -->
                        <!-- row -->
                        <div class="row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('admin.title')</label>
                                    <input type="text" name="deep_link_{{$i}}_title" class="form-control" value="{{old('deep_link_'.$i.'_title')}}" placeholder="@lang('admin.deep_link') {{$i}} @lang('admin.title')" />
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('admin.url')</label>
                                    <input type="text" name="deep_link_{{$i}}_url" class="form-control" value="{{old('deep_link_'.$i.'_url')}}" placeholder="@lang('admin.deep_link') {{$i}} @lang('admin.url')" />
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('admin.link_type')</label>
                                    <select title="@lang('admin.link_type')" name="deep_link_{{$i}}_type" class="form-control selectpicker" data-live-search="true">
                                        @foreach($link_types as $link_id => $link_type)
                                        <option value="{{ $link_id }}" {{ old('deep_link_'.$i.'_type') == $link_id ? 'selected' : '' }}>
                                            {{ $link_type }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                        </div>
                        <!-- /.row -->
                        @endfor

                        <hr class="divider" />

                        <!-- row -->
                        <div class="row">

                            <div class="col-md-12">
                                <label class="section-head">@lang('admin.other_contacts')</label>
                            </div>

                        </div>
                        <!-- /.row -->

                        <!-- row -->
                        <div class="row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('admin.facebook_url')</label>
                                    <input type="text" name="facebook_url" class="form-control" value="{{old('facebook_url')}}" placeholder="@lang('admin.facebook_url')" />
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('admin.twitter_url')</label>
                                    <input type="text" name="twitter_url" class="form-control" value="{{old('twitter_url')}}" placeholder="@lang('admin.twitter_url')" />
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('admin.instagram_url')</label>
                                    <input type="text" name="instagram_url" class="form-control" value="{{old('instagram_url')}}" placeholder="@lang('admin.instagram_url')" />
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('admin.linkedin_url')</label>
                                    <input type="text" name="linkedin_url" class="form-control" value="{{old('linkedin_url')}}" placeholder="@lang('admin.linkedin_url')" />
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('admin.whatsapp_number')</label>
                                    <input type="text" name="whatsapp_number" class="form-control" value="{{old('whatsapp_number')}}" placeholder="@lang('admin.whatsapp_number')" />
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('admin.telegram_url')</label>
                                    <input type="text" name="telegram_url" class="form-control" value="{{old('telegram_url')}}" placeholder="@lang('admin.telegram_url')" />
                                </div>
                            </div>

                        </div>
                        <!-- /.row -->

                        <hr class="divider" />

                        <!-- row -->
                        <div class="row">

                            <div class="col-md-12">
                                <label class="section-head">@lang('admin.seo_settings')</label>
                            </div>

                        </div>
                        <!-- /.row -->

                        <div class="form-group">
                            <label>@lang('admin.custom_title')</label>
                            <input type="text" name="custom_title" class="form-control" value="{{old('custom_title')}}" placeholder="@lang('admin.custom_title')" />
                        </div>

                        <div class="form-group">
                            <label>@lang('admin.custom_description')</label>
                            <textarea class="form-control" name="custom_description" rows="3" placeholder="@lang('admin.custom_description')">{{old('custom_description')}}</textarea>
                        </div>

                        <hr class="divider" />

                        <!-- row -->
                        <div class="row">

                            <div class="col-md-12">
                                <label class="section-head">@lang('admin.other_settings')</label>
                            </div>

                        </div>
                        <!-- /.row -->

                        <!-- row -->
                        <div class="row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('admin.owner') <span class="text-danger">*</span></label>
                                    <select title="@lang('admin.select_owner')" name="owner" class="form-control selectpicker" data-live-search="true">
                                        @foreach($users as $user)
                                        <option class="category-head" value="{{ $user->id }}" {{ old('owner', '1') == $user->id ? 'selected' : '' }}>#{{ $user->id }} - {{ $user->name }} - {{ $user->email }}</option>

                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('admin.package') <span class="text-danger">*</span></label>
                                    <select title="@lang('admin.select_package')" name="package" class="form-control selectpicker" data-live-search="true">
                                        <option class="category-head" value="0" selected>-</option>
                                        @foreach($packages as $package)
                                        <option class="category-head" value="{{ $package->id }}" {{ old('package') == $package->id ? 'selected' : '' }}>{{ $package->title }}</option>
                                        </option>

                                        @endforeach
                                    </select>
                                </div>
                            </div>

                        </div>
                        <!-- /.row -->

                        <!-- row -->
                        <div class="row">


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('admin.expire_time')</label>
                                    <input type="text" name="expire_at" id="expire_at" class="form-control" value="{{old('expire_at')}}" placeholder="@lang('admin.expire_time')" />
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('admin.votes')</label>
                                    <input type="text" name="votes" id="votes" class="form-control" value="{{old('votes') ?? '0.00'}}" placeholder="@lang('admin.votes')" />
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('admin.total_votes')</label>
                                    <input type="text" name="total_votes" id="total_votes" class="form-control" value="{{old('total_votes') ?? 0}}" placeholder="@lang('admin.total_votes')" />
                                </div>
                            </div>

                        </div>
                        <!-- /.row -->

                        <!-- row -->
                        <div class="row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('admin.enabled')</label><br />
                                    <input type="checkbox" name="enabled" id="enabled" @if(!old() || old('enabled')=='on' ) checked="checked" @endif>
                                </div>
                            </div>

                            <div class="col-md-4">

                                <div class="form-group">
                                    <label>@lang('admin.show_badge')</label><br />
                                    <input type="checkbox" name="badge" id="badge" {{ old('badge') == "on" ? 'checked' : '' }}>
                                </div>
                            </div>

                        </div>
                        <!-- /.row -->

                </div>
                <!-- /.box-body -->

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">@lang('admin.submit')</button>
                </div>

            </form>
            <!-- /.form -->

        </div>
        <!-- /.general form elements -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection