@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.edit_link'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- form -->
            <form method="POST" enctype="multipart/form-data" action="{{action('App\Http\Controllers\LinkController@update', $link->id)}}">
                @csrf @method('PUT')

                <!-- box-body -->
                <div class="box-body">

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('admin.url') <span class="text-danger">*</span></label>
                                <input type="text" name="url" id="url" class="form-control" value="{{$link->url}}" placeholder="@lang('admin.url')" />
                                <button onclick="get_details()" type="button" class="btn btn-primary btn-sm mt-5">@lang('admin.retrieve_details')</button>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('admin.slug')</label>
                                <input type="text" name="slug" class="form-control" value="{{$link->slug}}" placeholder="@lang('admin.slug')" />
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <div class="form-group">
                        <label>@lang('admin.title') <span class="text-danger">*</span></label>
                        <input type="text" name="title" id="title" class="form-control" value="{{$link->title}}" placeholder="@lang('admin.title')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.visible_url')</label>
                        <input type="text" name="visible_url" class="form-control" value="{{$link->visible_url}}" placeholder="@lang('admin.visible_url')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.description') <span class="text-danger">*</span></label>
                        <textarea class="form-control" name="description" id="description" rows="3" placeholder="@lang('admin.description')">{{$link->description}}</textarea>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.tags')</label>
                        <input type="text" name="tags" id="tags" class="form-control" data-role="tagsinput" value="{{$tags}}" placeholder="@lang('admin.tags')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.phone_number')</label>
                        <input type="text" name="phone_number" id="phone_number" class="form-control" value="{{$link->phone_number}}" placeholder="@lang('admin.phone_number')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.email')</label>
                        <input type="text" name="email" id="email" class="form-control" value="{{$link->email}}" placeholder="@lang('admin.email')" />
                    </div>

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">

                            <div class="form-group">
                                <label>@lang('admin.address')</label>
                                <textarea class="form-control" name="address" id="address" rows="3" placeholder="@lang('admin.address')">{{$link->address}}</textarea>
                            </div>

                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.category') <span class="text-danger">*</span></label>
                                <select title="@lang('admin.select_category')" name="categories[]" class="form-control selectpicker" id="multi-categories" multiple="multiple" data-live-search="true" required="required">
                                    @foreach($categories as $category)
                                    <option class="category-head" value="{{ $category->id }}" data-lang="{{ $category->language }}" data-content="[{{$array_data['language_code'][$category->language]}}] {{$category->title}}" @php if(in_array($category->id, $link->categories->pluck('id')->toArray())) { echo ' selected'; } @endphp></option>
                                    @foreach($category->children as $submenu)
                                    <option class="sub-category-head" data-lang="{{ $submenu->language }}" data-content="{{$submenu->title}}" value="{{ $submenu->id }}" @php if(in_array($submenu->id, $link->categories->pluck('id')->toArray())) { echo ' selected'; } @endphp></option>

                                    @endforeach

                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <script>
                        $('#multi-categories').on('loaded.bs.select', function(e) {
                            var value = $('option:selected', this).attr('data-lang');
                            var selectedOptions = jQuery('#multi-categories option:selected');

                            if (selectedOptions.length > 0) {
                                $("#multi-categories [data-lang!='" + value + "']").attr("disabled", "true");
                                $('#multi-categories').selectpicker('refresh');
                            } else {
                                $("#multi-categories [data-lang!='" + value + "']").removeAttr("disabled", "true");
                                $('#multi-categories').selectpicker('refresh');
                            }
                        });
                        $('#multi-categories').on('changed.bs.select', function(e) {
                            var value = $('option:selected', this).attr('data-lang');
                            var selectedOptions = jQuery('#multi-categories option:selected');

                            if (selectedOptions.length > 0) {
                                $("#multi-categories [data-lang!='" + value + "']").attr("disabled", "true");
                                $('#multi-categories').selectpicker('refresh');
                            } else {
                                $("#multi-categories [data-lang!='" + value + "']").removeAttr("disabled", "true");
                                $('#multi-categories').selectpicker('refresh');
                            }
                        });
                        </script>

                        <div class="col-md-4">

                            <div class="form-group">
                                <label>@lang('admin.city_country')</label>
                                <select title="@lang('admin.select_location')" name="locations" class="form-control selectpicker" id="locations" data-live-search="true">
                                    <option value="" data-content="None"></option>
                                    @foreach($locations as $location)
                                    <option class="category-head" value="{{ $location->id }}" data-lang="{{ $location->language }}" data-content="[{{$array_data['language_code'][$location->language]}}] {{$location->title}}" @php if(in_array($location->id, $link->locations->pluck('id')->toArray())) { echo ' selected'; } @endphp></option>

                                    @foreach($location->children as $submenu)
                                    <option class="sub-category-head" data-lang="{{ $submenu->language }}" data-content="{{$submenu->title}}" value="{{ $submenu->id }}" @php if(in_array($submenu->id, $link->locations->pluck('id')->toArray())) { echo ' selected'; } @endphp></option>

                                    @endforeach

                                    @endforeach
                                </select>
                            </div>

                        </div>

                    </div>
                    <!-- /.row -->

                    <script>
                    // Openlayers Map Functions
                    $(document).ready(function() {
                        "use strict";

                        if (document.getElementById("map")) {

                            var map_data = document.getElementById("map");
                            var map_title = map_data.getAttribute("data-title");
                            var map_lat = parseFloat(map_data.getAttribute("data-lat"));
                            var map_lon = parseFloat(map_data.getAttribute("data-lon"));
                            var map_zoom = parseFloat(map_data.getAttribute("data-zoom"));

                            var attribution = new ol.control.Attribution({
                                collapsible: false
                            });

                            var map = new ol.Map({
                                controls: ol.control.defaults({
                                    attribution: false
                                }).extend([attribution]),
                                layers: [
                                    new ol.layer.Tile({
                                        source: new ol.source.OSM({
                                            url: 'https://tile.openstreetmap.org/{z}/{x}/{y}.png',
                                            maxZoom: 18
                                        })
                                    })
                                ],
                                target: 'map',
                                view: new ol.View({
                                    center: ol.proj.fromLonLat([map_lon, map_lat]),
                                    maxZoom: 18,
                                    zoom: map_zoom,
                                })
                            });

                            var layer = new ol.layer.Vector({
                                source: new ol.source.Vector({
                                    features: [
                                        new ol.Feature({
                                            geometry: new ol.geom.Point(ol.proj.fromLonLat([map_lon, map_lat]))
                                        })
                                    ]
                                })
                            });

                            layer.set('name', 'map_marker');
                            map.addLayer(layer);

                            map.on('click', e => {
                                var point = map.getCoordinateFromPixel(e.pixel);
                                var lonLat = ol.proj.toLonLat(point);
                                var zoom = map.getView().getZoom();

                                var layer = new ol.layer.Vector({
                                    source: new ol.source.Vector({
                                        features: [
                                            new ol.Feature({
                                                geometry: new ol.geom.Point(ol.proj.fromLonLat([lonLat[0], lonLat[1]]))
                                            })
                                        ]
                                    })
                                });

                                map.getLayers().forEach(layer => {
                                    if (layer.get('name') && layer.get('name') == 'map_marker') {
                                        map.removeLayer(layer)
                                    }
                                });

                                layer.set('name', 'map_marker');
                                map.addLayer(layer);

                                $('#map_lon').val(lonLat[0]);
                                $('#map_lat').val(lonLat[1]);
                                $('#map_zoom').val(zoom);
                            })

                        }
                    });
                    </script>

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">

                            <div id="popup" class="shadow map-corner">
                                <div id="popup-content"></div>
                            </div>
                            <div id="map" data-title="{{$link->title}}" data-lat="{{$link->map_lat ?? '43'}}" data-lon="{{$link->map_lon ?? '23'}}" data-zoom="{{$link->map_zoom ?? '4'}}"></div>

                            <div class="row mt-3 mt-10">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>@lang('admin.map_lat')</label>
                                        <input type="text" name="map_lat" id="map_lat" class="form-control" value="{{$link->map_lat}}" placeholder="@lang('admin.map_lat')" />
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>@lang('admin.map_lon')</label>
                                        <input type="text" name="map_lon" id="map_lon" class="form-control" value="{{$link->map_lon}}" placeholder="@lang('admin.map_lon')" />
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>@lang('admin.map_zoom')</label>
                                        <input type="text" name="map_zoom" id="map_zoom" class="form-control" value="{{$link->map_zoom}}" placeholder="@lang('admin.map_zoom')" />
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.page_views') <span class="text-danger">*</span></label>
                                <input type="text" name="page_views" class="form-control" value="{{$link->page_views}}" placeholder="@lang('admin.page_views')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.clicks') <span class="text-danger">*</span></label>
                                <input type="text" name="clicks" class="form-control" value="{{$link->clicks}}" placeholder="@lang('admin.clicks')" />
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.featured_category')</label><br />
                                <input type="checkbox" name="featured_category" {{ $link->featured_category == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.featured_home')</label><br />
                                <input type="checkbox" name="featured_home" {{ $link->featured_home == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <div class="form-group">
                        <label>@lang('admin.hidden_content')</label>
                        <textarea class="textarea textarea-style" name="hidden_content" placeholder="@lang('admin.hidden_content')">{{$link->hidden_content}}</textarea>
                    </div>

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.images')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <a href="{{ asset('images/links') }}/{{ $link->image ?? 'no_image.png'; }}" data-toggle="lightbox"><img src="{{ asset('images/links') }}/{{ $link->image ?? 'no_image.png'; }}" class="img-responsive site-icon"></a>
                                <label>@lang('admin.site_icon')</label><br />
                                <label class="btn btn-outline btn-sm" id="browse-color-image">@lang('admin.browse')<input type="file" name="image" id="import-file-select" class="hidden"></label>
                                @if(isset($icon_queue) && $icon_queue->as_icon == '1')<span class="btn btn-outline btn-sm" id="generate-screenshot">@lang('admin.generating_icon') <i class="fas fa-spinner fa-spin"></i></span>@else @if($settings['thum_io_id'] != null & $settings['thum_io_url_key'] != null)<a href="{{ asset(env('ADMIN_URL').'/links?screenshot&id='.$link->id.'&as_icon=1') }}" class="btn btn-outline btn-sm" id="generate-screenshot">@lang('admin.generate_icon')</a>@endif @endif
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                @if(isset($link->screenshot))<a href="{{ asset('images/screenshots') }}/{{ $link->screenshot }}" data-toggle="lightbox"><img src="{{ asset('images/screenshots') }}/{{ $link->screenshot }}" class="img-responsive site-icon"></a>@endif
                                <label>@lang('admin.screenshot')</label><br />
                                <label class="btn btn-outline btn-sm" id="browse-color-screenshot">@lang('admin.browse')<input type="file" name="screenshot" id="import-file-select" class="hidden"></label>
                                @if(isset($screenshot_queue) && $screenshot_queue->as_icon == '0')<span class="btn btn-outline btn-sm" id="generate-screenshot">@lang('admin.generating_screenshot') <i class="fas fa-spinner fa-spin"></i></span>@else @if($settings['thum_io_id'] != null & $settings['thum_io_url_key'] != null)<a href="{{ asset(env('ADMIN_URL').'/links?screenshot&id='.$link->id.'&as_icon=0') }}" class="btn btn-outline btn-sm" id="generate-screenshot">@lang('admin.generate_screenshot')</a>@endif @endif
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.bypass_redirection_page')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.active')</label><br />
                                <input type="checkbox" name="bypass_redirect" id="bypass_redirect" {{ $link->bypass_redirect == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.link_type')</label>
                                <select title="@lang('admin.link_type')" name="bypass_type" id="bypass_type" class="form-control selectpicker" data-live-search="true">
                                    @foreach($link_types as $link_id => $bypass_type)
                                    <option value="{{ $link_id }}" {{ $link->bypass_type == $link_id ? ' selected' : '' }}>
                                        {{ $bypass_type }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.bypass_details_page')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.active')</label><br />
                                <input type="checkbox" name="bypass_details" id="bypass_details" {{ $link->bypass_details == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.link_type')</label>
                                <select title="@lang('admin.link_type')" name="bypass_details_type" id="bypass_details_type" class="form-control selectpicker" data-live-search="true">
                                    @foreach($link_types as $link_id => $bypass_details_type)
                                    <option value="{{ $link_id }}" {{ $link->bypass_details_type == $link_id ? ' selected' : '' }}>
                                        {{ $bypass_details_type }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.deep_links')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    @foreach($deep_link_data as $title)

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.title')</label>
                                <input type="text" name="deep_link_{{$loop->iteration}}_title" class="form-control" value="{{$title['title']}}" placeholder="@lang('admin.deep_link') {{$loop->iteration}} @lang('admin.title')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.url')</label>
                                <input type="text" name="deep_link_{{$loop->iteration}}_url" class="form-control" value="{{$title['url']}}" placeholder="@lang('admin.deep_link') {{$loop->iteration}} @lang('admin.url')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.link_type')</label>
                                <select title="@lang('admin.link_type')" name="deep_link_{{$loop->iteration}}_type" class="form-control selectpicker" data-live-search="true">
                                    @foreach($link_types as $link_id => $link_type)
                                    <option value="{{ $link_id }}" {{ $title['type']==$link_id ? ' selected' : '' }}>
                                        {{ $link_type }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    @endforeach

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.other_contacts')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.facebook_url')</label>
                                <input type="text" name="facebook_url" class="form-control" value="{{$other_contacts['facebook_url']['url']}}" placeholder="@lang('admin.facebook_url')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.twitter_url')</label>
                                <input type="text" name="twitter_url" class="form-control" value="{{$other_contacts['twitter_url']['url']}}" placeholder="@lang('admin.twitter_url')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.instagram_url')</label>
                                <input type="text" name="instagram_url" class="form-control" value="{{$other_contacts['instagram_url']['url']}}" placeholder="@lang('admin.instagram_url')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.linkedin_url')</label>
                                <input type="text" name="linkedin_url" class="form-control" value="{{$other_contacts['linkedin_url']['url']}}" placeholder="@lang('admin.linkedin_url')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.whatsapp_number')</label>
                                <input type="text" name="whatsapp_number" class="form-control" value="{{$other_contacts['whatsapp_number']['number']}}" placeholder="@lang('admin.whatsapp_number')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.telegram_url')</label>
                                <input type="text" name="telegram_url" class="form-control" value="{{$other_contacts['telegram_url']['url']}}" placeholder="@lang('admin.telegram_url')" />
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.seo_settings')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <div class="form-group">
                        <label>@lang('admin.custom_title')</label>
                        <input type="text" name="custom_title" class="form-control" value="{{$link->custom_title}}" placeholder="@lang('admin.custom_title')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.custom_description')</label>
                        <textarea class="form-control" name="custom_description" rows="3" placeholder="@lang('admin.custom_description')">{{$link->custom_description}}</textarea>
                    </div>

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <label class="section-head">@lang('admin.other_settings')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.owner') <span class="text-danger">*</span></label>
                                <select title="@lang('admin.select_owner')" name="owner" class="form-control selectpicker" data-live-search="true">
                                    @foreach($users as $user)
                                    <option class="category-head" value="{{ $user->id }}" {{ $link->owner == $user->id ? ' selected' : '' }}>#{{ $user->id }} - {{ $user->name }} - {{ $user->email }}</option>

                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.package') <span class="text-danger">*</span></label>
                                <select title="@lang('admin.select_package')" name="package" class="form-control selectpicker" data-live-search="true">
                                    <option class="category-head" value="0" {{ $link->package == 0 ? ' selected' : '' }}>-</option>
                                    @foreach($packages as $package)
                                    <option class="category-head" value="{{ $package->id }}" {{ $link->package == $package->id ? ' selected' : '' }}>{{ $package->title }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.expire_time')</label>
                                <input type="text" name="expire_at" id="expire_at" class="form-control" value="{{$link->expire_at}}" placeholder="@lang('admin.expire_time')" />
                            </div>

                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.votes')</label>
                                <input type="text" name="votes" id="votes" class="form-control" value="{{$link->votes}}" placeholder="@lang('admin.votes')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.total_votes')</label>
                                <input type="text" name="total_votes" id="total_votes" class="form-control" value="{{$link->total_votes}}" placeholder="@lang('admin.total_votes')" />
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.enabled')</label><br />
                                <input type="checkbox" name="enabled" id="enabled" {{ $link->enabled == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.show_badge')</label><br />
                                <input type="checkbox" name="badge" id="badge" {{ $link->badge == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                </div>
                <!-- /.box-body -->

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">@lang('admin.submit')</button>
                </div>

            </form>
            <!-- /.form -->

        </div>
        <!-- /.general form elements -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->


<!-- general form elements -->
<div class="box">

    <!-- box-body -->
    <div class="box-body" id="gallery" data-content-deleted="@lang('admin.content_deleted')" data-succesfully-deleted="@lang('admin.content_succesfully_deleted')">

        <form method="post" action="{{ route('upload', ['link_id'=>$link->id]) }}" id="gallery_form" enctype="multipart/form-data">
            @csrf
            <div class="form-group">
              
              <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.gallery')</label>
                        </div>

                    </div>
                    <!-- /.row -->

              
                <label class="btn btn-outline btn-sm" id="browse-color-image">@lang('admin.browse')<input type="file" name="file[]" id="file" accept="image/*" class="hidden" multiple /></label>
            </div>

            <input type="submit" name="upload" value="@lang('admin.upload')" class="btn btn-primary mb-10" />
        </form>

        <div class="progress">
            <div class="progress-bar" aria-valuenow="" aria-valuemin="0" aria-valuemax="100">
                0%
            </div>
        </div>

        <div id="success" class="row">
            @php
            if ($link->gallery != "") {

            $mysplit = explode(',', $link->gallery);
            $galery_data = array_reverse($mysplit);

            $image_code_s = '';
            foreach($galery_data as $gallery) {
            $image_code_s .= '<div class="col-md-2 mb-10 text-center"><img src="/images/uploads/'.$gallery.'" class="img-thumbnail" /><button type="button" data-name="'.$gallery.'" data-link-id="'.$link->id.'" class="btn btn-danger mt-10 remove_gallery">' . __('admin.delete') . '</button></div>';
            }
            echo $image_code_s;
            } else {
            echo '<div class="text-center"><b>' . __('admin.no_images_yet') . '</b></div><br />';
            }
            @endphp
        </div>

    </div>
    <!-- /.box -->

</div>
<!-- /.general form elements -->

@endsection