@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.edit_location'))

@if(empty($category->image))
@php $category->image='no_image.png'; @endphp
@endif

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- form -->
            <form method="POST" enctype="multipart/form-data" action="{{action('App\Http\Controllers\LocationController@update', $id)}}">
                @csrf @method('PUT')

                <!-- box-body -->
                <div class="box-body">

                    @if($category->parent_id == '0' )

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.language') <span class="text-danger">*</span></label>
                                <select title="@lang('admin.select_language')" name="language" class="form-control selectpicker" data-live-search="true">
                                    @foreach($translations as $translation)
                                    <option value="{{ $translation->id }}" data-content="<span class='fi fi-{{$translation['icon']}}'></span> {{$translation['language']}}" {{ $category->language == $translation->id ? ' selected' : '' }}></option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    @endif

                    <div class="form-group">
                        <label>@lang('admin.title') <span class="text-danger">*</span></label>
                        <input type="text" name="title" class="form-control" value="{{$category->title}}" placeholder="@lang('admin.title')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.slug')</label>
                        <input type="text" name="slug" class="form-control" value="{{$category->slug}}" placeholder="@lang('admin.slug')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.country')</label>
                        <select title="@lang('admin.select_country')" name="parent_id" class="form-control selectpicker" data-live-search="true">
                            @if($category->parent_id=='0')
                            <option class="category-head" value="0" selected>@lang('admin.none')</option>
                            @endif
                            @foreach($categories as $main_category)
                            @if($main_category->id != $category->id)
                            <option @if(count($category->children)>='1') disabled @endif class="category-head" value="{{ $main_category->id }}" data-content="[{{$array_data['language_code'][$main_category->language]}}] {{$main_category->title}}"
                                {{ $category->parent_id == $main_category->id ? ' selected' : '' }}></option>
                            @endif

                            @endforeach

                        </select>
                    </div>

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.seo_settings')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <div class="form-group">
                        <label>@lang('admin.custom_title')</label>
                        <input type="text" name="custom_title" class="form-control" value="{{$category->custom_title}}" placeholder="@lang('admin.custom_title')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.custom_description')</label>
                        <textarea class="form-control" name="custom_description" rows="3" placeholder="@lang('admin.custom_description')">{{$category->custom_description}}</textarea>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.custom_content')</label>
                        <textarea class="textarea textarea-style" name="custom_content" placeholder="@lang('admin.custom_content')">{{$category->custom_content}}</textarea>
                    </div>

                </div>
                <!-- /.box-body -->

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">@lang('admin.submit') </button>
                </div>

            </form>
            <!-- /.form -->

        </div>
        <!-- /.general form elements -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection