<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>
        @yield('title_prefix', config('adminlte.title_prefix', ''))
        @yield('title', config('adminlte.title', 'AdminLTE 3'))
        @yield('title_postfix', config('adminlte.title_postfix', ''))@hasSection('content_header') - @yield('content_header')@endif
    </title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <link rel="icon" type="image/png" href="{{ asset('images/favicon.png') }}" />
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
    <base href="{{ asset(env('ADMIN_URL')) }}">

    <!-- Bootstrap -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/vendor/bootstrap/dist/css/bootstrap.min.css') }}">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/vendor/font-awesome/css/all.min.css') }}">
    <!-- Ionicons -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/vendor/Ionicons/css/ionicons.min.css') }}">
    <!-- Flag Icons -->
    <link rel="stylesheet" href="{{ asset('css/flag-icons.min.css') }}">
    <!-- Bootstrap-select -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/bootstrap-select.min.css') }}">
    <!-- AdminLTE Theme style -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/AdminLTE.min.css') }}">
    <!-- Adminlte Purple skin -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/skins/skin-purple.min.css') }}">
    <!-- Summernote Text Editor -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/vendor/summernote/summernote.css') }}">
    <!-- iCheck plugin Square skin -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/js/iCheck/square/purple.css') }}">
    <!-- SweetAlert2 -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/sweetalert2.css') }}">
    <!-- Jquery UI -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/jquery-ui.min.css') }}">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/custom.css') }}">
    <!-- Ekko Lightbox -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/ekko-lightbox.css') }}">
    <!-- Time Picker -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/jquery-ui-timepicker-addon.css') }}">
    <!-- Bootstrap Colorpicker -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/bootstrap-colorpicker.min.css') }}">
    <!-- Bootstrap-tagsinput -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/tagsinput.css') }}">
    <!-- OpenLayers -->
    <link rel="stylesheet" href="{{ asset('css/ol.css') }}">

    <!-- Jquery -->
    <script src="{{ asset('vendor/adminlte/vendor/jquery/dist/jquery.min.js') }}"></script>
    <!-- jQuery Form Plugin -->
    <script src="{{ asset('vendor/adminlte/dist/js/jquery.form.min.js') }}"></script>
    <!-- Custom JS -->
    <script src="{{ asset('vendor/adminlte/dist/js/custom.js') }}"></script>
    <!-- Bootstrap-select -->
    <script src="{{ asset('vendor/adminlte/dist/js/bootstrap-select.min.js') }}"></script>
    <!-- iCheck -->
    <script src="{{ asset('vendor/adminlte/dist/js/iCheck/icheck.min.js') }}"></script>
    <!-- jQuery UI -->
    <script src="{{ asset('vendor/adminlte/vendor/other/jquery-ui.js') }}"></script>
    <!-- jQuery UI Touch Punch -->
    <script src="{{ asset('vendor/adminlte/vendor/other/jquery.ui.touch-punch.min.js') }}"></script>
    <!-- SweetAlert2 -->
    <script src="{{ asset('vendor/adminlte/dist/js/sweetalert2.js') }}"></script>

    @if (Request::is('login'))
    @if ($settings['enable_google_recaptcha'] == '1')
    <!-- Google reCAPTCHA -->
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    @endif
    @endif

    <!--[if lt IE 9]>
    <script src="{{ asset('vendor/adminlte/vendor/other/html5shiv.min.js') }}"></script>
    <script src="{{ asset('vendor/adminlte/vendor/other/respond.min.js') }}"></script>
    <![endif]-->
</head>

<body class="hold-transition @yield('body_class')">

    @yield('body')

    <!-- OpenLayers -->
    <script src="{{ asset('js/ol.js') }}"></script>
    <!-- Bootstrap -->
    <script src="{{ asset('vendor/adminlte/vendor/bootstrap/dist/js/bootstrap.min.js') }}"></script>
    
    <!-- Summernote Text Editor -->
    <script src="{{ asset('vendor/adminlte/vendor/summernote/summernote.js') }}"></script>
    <!-- Ekko Lightbox -->
    <script src="{{ asset('vendor/adminlte/dist/js/ekko-lightbox.min.js') }}"></script>
    <!-- AdminLTE -->
    <script src="{{ asset('vendor/adminlte/dist/js/adminlte.min.js') }}"></script>
    <!-- Time Picker -->
    <script src="{{ asset('vendor/adminlte/dist/js/jquery-ui-timepicker-addon.js') }}"></script>
    <!-- Bootstrap Colorpicker -->
    <script src="{{ asset('vendor/adminlte/dist/js/bootstrap-colorpicker.min.js') }}"></script>
    <!-- Bootstrap-tagsinput -->
    <script src="{{ asset('vendor/adminlte/dist/js/tagsinput.js') }}"></script>
</body>

</html>