@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.create_member'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- form -->
            <form method="POST" enctype="multipart/form-data" action="{{url(env('ADMIN_URL').'/members')}}">
                @csrf @method('POST')

                <!-- box-body -->
                <div class="box-body">

                    <div class="form-group">
                        <label>@lang('admin.name') <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control" value="{{old('name')}}" placeholder="@lang('admin.name')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.email') <span class="text-danger">*</span></label>
                        <input type="text" name="email" class="form-control" value="{{old('email')}}" placeholder="@lang('admin.email')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.password') <span class="text-danger">*</span></label>
                        <input type="password" name="password" class="form-control" placeholder="@lang('admin.password')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.confirm_password') <span class="text-danger">*</span></label>
                        <input type="password" name="password_confirmation" class="form-control" placeholder="@lang('admin.confirm_password')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.account_activated') </label><br />
                        <input type="checkbox" name="activated" @if(!old() || old('activated')=='on' ) checked="checked" @endif>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.account_disabled')</label><br />
                        <input type="checkbox" name="disabled" {{ old('disabled') == "on" ? 'checked' : '' }}>
                    </div>

                </div>
                <!-- /.box-body -->

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">@lang('admin.submit')</button>
                </div>

            </form>
            <!-- /.form -->

        </div>
        <!-- /.general form elements -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection