@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.send_email'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- form -->
            <form method="POST" enctype="multipart/form-data" action="{{url(env('ADMIN_URL').'/members/send_email/'.request()->id)}}">
                @csrf @method('POST')

                <!-- box-body -->
                <div class="box-body">

                    <div class="form-group">
                        <label>@lang('admin.subject') <span class="text-danger">*</span></label>
                        <input type="text" name="subject" class="form-control" value="{{old('subject')}}" placeholder="@lang('admin.subject')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.message') <span class="text-danger">*</span></label>
                        <textarea class="form-control" name="message" rows="10" placeholder="@lang('admin.message')">{{old('message')}}</textarea>
                    </div>

                </div>
                <!-- /.box-body -->

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">@lang('admin.send')</button>
                </div>

            </form>
            <!-- /.form -->

        </div>
        <!-- /.general form elements -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection