@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.edit_package'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- form -->
            <form method="POST" enctype="multipart/form-data" action="{{action('App\Http\Controllers\PackageController@update', $id)}}">
                @csrf @method('PUT')

                <!-- box-body -->
                <div class="box-body">

                    <div class="form-group">
                        <label>@lang('admin.available') </label><br />
                        <input type="checkbox" name="available" {{ $package->available == 1 ? 'checked' : '' }}>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.duration') <span class="text-danger">*</span></label>
                        <select title="@lang('admin.duration')" name="duration" id="duration" class="form-control selectpicker" data-live-search="true">
                            <option value="0" {{ $package->duration == 0 ? ' selected' : '' }}>@lang('admin.unlimited')</option>
                            <option value="1" {{ $package->duration == 1 ? ' selected' : '' }}>@lang('admin.daily')</option>
                            <option value="2" {{ $package->duration == 2 ? ' selected' : '' }}>@lang('admin.weekly')</option>
                            <option value="3" {{ $package->duration == 3 ? ' selected' : '' }}>@lang('admin.monthly')</option>
                            <option value="4" {{ $package->duration == 4 ? ' selected' : '' }}>@lang('admin.3_months')</option>
                            <option value="5" {{ $package->duration == 5 ? ' selected' : '' }}>@lang('admin.6_months')</option>
                            <option value="6" {{ $package->duration == 6 ? ' selected' : '' }}>@lang('admin.9_months')</option>
                            <option value="7" {{ $package->duration == 7 ? ' selected' : '' }}>@lang('admin.yearly')</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.title') <span class="text-danger">*</span></label>
                        <input type="text" name="title" class="form-control" value="{{$package->title}}" placeholder="@lang('admin.title')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.price') <span class="text-danger">*</span></label>
                        <input type="text" name="price" class="form-control" value="{{$package->price}}" placeholder="@lang('admin.price')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.price_without_discount')</label>
                        <input type="text" name="real_price" class="form-control" value="{{$package->real_price}}" placeholder="@lang('admin.price_without_discount')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.description')</label>
                        <textarea class="form-control" name="description" rows="3" placeholder="@lang('admin.description')">{{$package->description}}</textarea>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.reciprocal_link_required') </label><br />
                        <input type="checkbox" name="reciprocal_link" {{ $package->reciprocal_link == 1 ? 'checked' : '' }}>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.featured_category') </label><br />
                        <input type="checkbox" name="featured_category" {{ $package->featured_category == 1 ? 'checked' : '' }}>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.featured_home') </label><br />
                        <input type="checkbox" name="featured_home" {{ $package->featured_home == 1 ? 'checked' : '' }}>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.allow_changing_visible_url')</label><br />
                        <input type="checkbox" name="visible_url" {{ $package->visible_url == 1 ? 'checked' : '' }}>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.allow_phone_number')</label><br />
                        <input type="checkbox" name="phone_number" {{ $package->phone_number == 1 ? 'checked' : '' }}>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.allow_email')</label><br />
                        <input type="checkbox" name="email" {{ $package->email == 1 ? 'checked' : '' }}>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.allow_address')</label><br />
                        <input type="checkbox" name="address" {{ $package->address == 1 ? 'checked' : '' }}>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.allow_other_contacts')</label><br />
                        <input type="checkbox" name="other_contacts" {{ $package->other_contacts == 1 ? 'checked' : '' }}>
                    </div>

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.bypass_redirection_page')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>@lang('admin.allowed')</label><br />
                                <input type="checkbox" id="bypass_redirect" name="bypass_redirect" {{ $package->bypass_redirect == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>@lang('admin.link_type')</label>
                                <select title="@lang('admin.link_type')" name="bypass_type" id="bypass_type" class="form-control selectpicker" data-live-search="true">
                                    @foreach($link_types as $link_id => $bypass_type)
                                    <option value="{{ $link_id }}" {{ $package->bypass_redirect_type == $link_id ? ' selected' : '' }}>
                                        {{ $bypass_type }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.bypass_details_page')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>@lang('admin.allowed')</label><br />
                                <input type="checkbox" id="bypass_details" name="bypass_details" {{ $package->bypass_details == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>@lang('admin.link_type')</label>
                                <select title="@lang('admin.link_type')" name="bypass_details_type" id="bypass_details_type" class="form-control selectpicker" data-live-search="true">
                                    @foreach($link_types as $link_id => $bypass_details_type)
                                    <option value="{{ $link_id }}" {{ $package->bypass_details_type == $link_id ? ' selected' : '' }}>
                                        {{ $bypass_details_type }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.deep_links')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>@lang('admin.allowed')</label><br />
                                <input type="checkbox" id="deep_links" name="deep_links" {{ $package->deep_links == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>@lang('admin.allowed_deep_links_count')</label>
                                <input type="text" name="deep_links_count" id="deep_links_count" class="form-control" value="{{$package->deep_links_count}}" placeholder="@lang('admin.allowed_deep_links_count')" />
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>@lang('admin.link_type')</label>
                                <select title="@lang('admin.link_type')" name="deep_links_type" id="deep_links_type" class="form-control selectpicker" data-live-search="true">
                                    @foreach($link_types as $link_id => $bypass_type)
                                    <option value="{{ $link_id }}" {{ $package->deep_links_type == $link_id ? ' selected' : '' }}>
                                        {{ $bypass_type }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                </div>
                <!-- /.box-body -->

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">@lang('admin.submit')</button>
                </div>

            </form>
            <!-- /.form -->

        </div>
        <!-- /.general form elements -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection