@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.bank_payment_notification_approval'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- box-body -->
            <div class="box-body">

                <b>@lang('admin.sender_name'):</b> {{$payment_notification->sender_name}}<br />
                <b>@lang('admin.bank_name'):</b> {{$payment_notification->bank_name}}<br />
                <b>@lang('admin.amount'):</b> {{$settings['payment_currency_symbol']}}{{$payment_notification->price}}<br />
                <b>@lang('admin.details'):</b> {{$payment_notification->details}}<br />

                <a href="{{ asset(env('ADMIN_URL').'/payment_notification/'.$payment_notification->id.'') }}?bank_payment=1"><span class="approve-button"><i class="fas fa-check"></i> @lang('admin.approve')</span></a>
                <a href="{{ asset(env('ADMIN_URL').'/payment_notification/'.$payment_notification->id.'') }}?bank_payment=2"><span class="deny-button"><i class="fas fa-ban"></i> @lang('admin.deny')</span></a>
                <a href="{{ asset(env('ADMIN_URL').'/members/send_email/'.$payment_notification->user.'') }}"><span class="mail-button"><i class="fas fa-paper-plane"></i> @lang('admin.send_email_to_member')</span></a>

            </div>
            <!-- /.box-body -->


        </div>
        <!-- /.general form elements -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection