@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.payment_listing_settings'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- form -->
            <form method="POST" enctype="multipart/form-data" action="{{url(env('ADMIN_URL').'/payment_listing_settings')}}">
                @csrf @method('POST')

                <!-- box-body -->
                <div class="box-body">

                    <div class="row">
                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.general_settings')</label>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.payment_currency') <span class="text-danger">*</span></label>
                        <input type="text" name="payment_currency" class="form-control" value="{{$settings['payment_currency']}}" placeholder="@lang('admin.payment_currency')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.payment_currency_symbol') <span class="text-danger">*</span></label>
                        <input type="text" name="payment_currency_symbol" class="form-control" value="{{$settings['payment_currency_symbol']}}" placeholder="@lang('admin.payment_currency_symbol')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.grace_period_hours')</label>
                        <input type="text" name="grace_period" class="form-control" value="{{$settings['grace_period']}}" placeholder="@lang('admin.grace_period_hours')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.cronjob_url') <a href="{{asset(env('ADMIN_URL').'/settings')}}?cronjob_code"><u>@lang('admin.generate_new_link')</u></a></label>
                        <input type="text" class="form-control" value="{{asset('/cronjob')}}/{{$settings['cronjob_code']}}" placeholder="@lang('admin.auto_submission_crontab_link')" readonly />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.paypal_webhook_url') <a href="{{asset(env('ADMIN_URL').'/settings')}}?paypal_webhook_code"><u>@lang('admin.generate_new_link')</u></a></label>
                        <input type="text" class="form-control" value="{{asset('/api/paypal-webhook')}}/{{$settings['paypal_webhook_code']}}" placeholder="@lang('admin.crontab_link')" readonly />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.reciprocal_link_code')</label>
                        <textarea class="form-control" name="reciprocal_link_code" rows="3" placeholder="@lang('admin.reciprocal_link_code')">{{$settings['reciprocal_link_code']}}</textarea>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.category_sort_by')</label>
                        <select title="@lang('admin.category_sort_by')" name="category_sort_by" class="form-control selectpicker" data-live-search="true">
                            <option value="NewestFirst" {{ $settings['category_sort_by'] == 'NewestFirst' ? ' selected' : '' }}>@lang('admin.newest_first')</option>
                            <option value="OldestFirst" {{ $settings['category_sort_by'] == 'OldestFirst' ? ' selected' : '' }}>@lang('admin.oldest_first')</option>
                            <option value="Ascending" {{ $settings['category_sort_by'] == 'Ascending' ? ' selected' : '' }}>@lang('admin.title_ascending')</option>
                            <option value="Descending" {{ $settings['category_sort_by'] == 'Descending' ? ' selected' : '' }}>@lang('admin.title_descending')</option>
                            <option value="MostViews" {{ $settings['category_sort_by'] == 'MostViews' ? ' selected' : '' }}>@lang('admin.most_page_views')</option>
                            <option value="LeastViews" {{ $settings['category_sort_by'] == 'LeastViews' ? ' selected' : '' }}>@lang('admin.least_page_views')</option>
                            <option value="MostClicks" {{ $settings['category_sort_by'] == 'MostClicks' ? ' selected' : '' }}>@lang('admin.most_clicks')</option>
                            <option value="LeastClicks" {{ $settings['category_sort_by'] == 'LeastClicks' ? ' selected' : '' }}>@lang('admin.least_clicks')</option>
                            <option value="MostVotes" {{ $settings['category_sort_by'] == 'MostVotes' ? ' selected' : '' }}>@lang('admin.most_votes')</option>
                            <option value="LeastVotes" {{ $settings['category_sort_by'] == 'LeastVotes' ? ' selected' : '' }}>@lang('admin.least_votes')</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.popular_links_sort_by')</label>
                        <select title="@lang('admin.popular_links_sort_by')" name="popular_links_sort_by" class="form-control selectpicker" data-live-search="true">
                            <option value="1" {{ $settings['popular_links_sort_by'] == '1' ? ' selected' : '' }}>@lang('admin.most_page_views')</option>
                            <option value="2" {{ $settings['popular_links_sort_by'] == '3' ? ' selected' : '' }}>@lang('admin.most_clicks')</option>
                            <option value="3" {{ $settings['popular_links_sort_by'] == '2' ? ' selected' : '' }}>@lang('admin.most_votes')</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.domain_blacklist')</label>
                        <textarea class="form-control" name="domain_blacklist" rows="6" placeholder="@lang('admin.domain_blacklist')">{{$settings['domain_blacklist']}}</textarea>
                    </div>

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.allow_user_updates')</label><br />
                                <input type="checkbox" name="allow_user_updates" {{ $settings['allow_user_updates'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <div class="row">
                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.allowed_payment_methods')</label>
                        </div>
                    </div>

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.paypal_one_time')</label><br />
                                <input type="checkbox" name="1" {{ $payment_methods['1']->enabled == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.paypal_subscription')</label><br />
                                <input type="checkbox" name="5" {{ $payment_methods['5']->enabled == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.bank_transfer')</label><br />
                                <input type="checkbox" name="2" {{ $payment_methods['2']->enabled == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.stripe')</label><br />
                                <input type="checkbox" name="3" {{ $payment_methods['3']->enabled == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.cryptocurrency')</label><br />
                                <input type="checkbox" name="4" {{ $payment_methods['4']->enabled == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                </div>
                <!-- /.box-body -->

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">@lang('admin.submit')</button>
                </div>

            </form>
            <!-- /.form -->

        </div>
        <!-- /.general form elements -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection