@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.create_link'))

@if(empty($order->image))
@php $order->image='no_image.png'; @endphp
@endif

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <div class="modal fade" id="myModal">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button class="close" data-dismiss="modal">&times;</button>
                        <h4 class="modal-title">@lang('admin.order_details')</h4>

                        <div class="modal-body table-body">

                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <tbody>
                                        <tr>
                                            <th>@lang('admin.name')</th>
                                            <td>{{$order->user_name}}</td>
                                        </tr <tr>
                                        <th>@lang('admin.email')</th>
                                        <td>{{$order->user_email}}</td>
                                        </tr>
                                        @if($order->payment_method != '0')
                                        <tr>
                                            <th>@lang('admin.payment_method')</th>
                                            <td>{{$data_to_pass['payment_method']}}</td>
                                        </tr>
                                        @endif
                                        <tr>
                                            <th>@lang('admin.package')</th>
                                            <td>{{$data_to_pass['package_name']}}</td>
                                        </tr>
                                        @if($order->reciprocal_link != null)
                                        <th>@lang('admin.reciprocal_link')</th>
                                        <td><a href="{{$order->reciprocal_link}}" target="_blank">{{$order->reciprocal_link}}</a>
                                            @endif
                                            <tr>
                                                <th>@lang('admin.date')</th>
                                                <td>{{\Carbon\Carbon::parse($order->created_at)->translatedFormat('F d, Y H:i:s')}}</td>
                                            </tr>
                                            <tr>
                                                <th>@lang('admin.ip_address')</th>
                                                <td>{{$order->ip}}</td>
                                            </tr>

                                    </tbody>
                                </table>

                            </div>

                        </div>

                        @if($order->payment_method != '0' && $order->subscription_id == null)
                        <h4 class="modal-title">@lang('admin.payment_details')</h4>
                        @endif

                        @if($order->payment_method == '4')

                        <div class="modal-body table-body">

                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <tbody>
                                        <tr>
                                            <th>@lang('admin.amount')</th>
                                            <td>{{$order->currency_symbol}}{{$order->price}}</td>
                                        </tr>
                                        <tr>
                                            <th>@lang('admin.transaction_id')</th>
                                            <td>{{$crypto_payment->transaction_id}}</td>
                                        </tr>
                                        <tr>
                                            <th>@lang('admin.network')</th>
                                            <td>{{$crypto_payment->network}}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        @endif

                        @if($order->payment_method == '3')

                        <div class="modal-body table-body">

                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <tbody>
                                        <tr>
                                            <th>@lang('admin.amount')</th>
                                            <td>{{$order->currency_symbol}}{{$order->price}}</td>
                                        </tr>
                                        @isset($order->subscription_id)
                                        <tr>
                                            <th>@lang('admin.billing_agreement_id')</th>
                                            <td>{{$order->subscription_id}}</td>
                                        </tr>
                                        @endif
                                        @isset($order->payment_id)
                                        <tr>
                                            <th>@lang('admin.order_id')</th>
                                            <td>{{$order->payment_id}}</td>
                                        </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        @endif

                        @if($order->payment_method == '1')
                        <div class="modal-body table-body">

                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <tbody>
                                        @isset($order->subscription_id)
                                        <tr>
                                            <th>@lang('admin.billing_agreement_id')</th>
                                            <td>{{$order->subscription_id}}</td>
                                        </tr>
                                        @endif
                                        @isset($order->payment_id)
                                        <tr>
                                            <th>@lang('admin.order_id')</th>
                                            <td>{{$order->payment_id}}</td>
                                        </tr>
                                        @endif

                                    </tbody>
                                </table>
                            </div>
                        </div>
                        @endif

                        @if($order->payment_method == '2')

                        <div class="modal-body table-body">

                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <tbody>
                                        <tr>
                                            <th>@lang('admin.amount')</th>
                                            <td>{{$order->currency_symbol}}{{$order->price}}</td>
                                        </tr>
                                        <tr>
                                            <th>@lang('admin.sender_name')</th>
                                            <td>{{$payment_notification->sender_name}}</td>
                                        </tr>
                                        <tr>
                                            <th>@lang('admin.bank_account')</th>
                                            <td>{{$data_to_pass['bank_name']}}</td>
                                        </tr>
                                        <tr>
                                            <th>@lang('admin.details')</th>
                                            <td>{{$payment_notification->details}}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <a href="{{Request::url()}}?payment_not_received" class="btn btn-block btn-danger">@lang('admin.payment_not_received')</a>

                        @endif

                        @isset($order->subscription_id)

                        <h4 class="modal-title">@lang('admin.payment_details')</h4>
                        <div class="modal-body table-body">

                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <tbody>
                                        @isset($order->subscription_id)
                                        <tr>
                                            <th>@lang('admin.billing_agreement_id')</th>
                                            <td>{{$order->subscription_id}}</td>
                                        </tr>
                                        @endif
                                        @isset($order->payment_id)
                                        <tr>
                                            <th>@lang('admin.order_id')</th>
                                            <td>{{$order->payment_id}}</td>
                                        </tr>
                                        @endif

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <h4 class="modal-title">@lang('admin.payment_history')</h4>

                        <div class="modal-body table-body">

                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <tbody>
                                        @foreach($subscription_payments as $payment)
                                        <tr>
                                            <th>{{$payment->created_at}}</th>
                                            <td class="text-success">+{{$payment->currency_symbol}}{{$payment->price}}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        @endif

                    </div>
                </div>
            </div>
        </div>

        <!-- modal -->

        <!-- /.modal -->

        <!-- general form elements -->
        <div class="box">

            <!-- box-body -->
            <div class="box-body">

                <div class="row" id="submission-actions" data-delete-prompt="@lang('admin.delete_prompt')" data-yes="@lang('admin.yes')" data-cancel="@lang('admin.cancel')" data-reason="@lang('admin.rejection_reason')">
                    <div class="col-md-3 mb-10">
                        <a data-target="#myModal" role="button" data-toggle="modal" class="btn btn-sm order-details-btn">
                            <i class="fas fa-list"></i> @lang('admin.click_to_see_order_details')</a>
                    </div>

                    <div class="col-md-3 mb-10">
                        <a href="{{ asset(env('ADMIN_URL').'/members/send_email/'.$order->user.'') }}" class="btn btn-sm send-email-btn">
                            <i class="fas fa-paper-plane"></i> @lang('admin.send_email_to_member')</a>
                    </div>

                    <div class="col-md-3 mb-10">
                        <form id="submission_delete_from_{{$order->id}}" method="POST" action="{{action('App\Http\Controllers\SubmissionController@destroy', $order->id)}}">
                            {{ csrf_field() }}
                            {{ method_field('DELETE') }}
                            <a href="javascript:void(0);" data-id="{{$order->id}}" class="_submission_delete_data btn btn-sm deny-btn">
                                <i class="fas fa-ban"></i> @lang('admin.deny_submission')</a>
                        </form>
                    </div>

                    <div class="col-md-3 mb-10">
                        <a href="{{ asset(env('ADMIN_URL').'/submissions') }}" class="btn btn-sm decide-later-btn">
                            <i class="fas fa-clock"></i> @lang('admin.decide_later')</a>
                    </div>

                </div>

                <!-- form -->
                <form method="POST" enctype="multipart/form-data" action="{{url(env('ADMIN_URL').'/submissions')}}">
                    @csrf @method('POST')

                    <input type="hidden" name="image" value="{{$order->image}}" />
                    <input type="hidden" name="submission_id" value="{{$order->id}}" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('admin.url') <span class="text-danger">*</span></label>
                                <input type="text" name="url" class="form-control" value="{{$order->url}}" placeholder="@lang('admin.url')" />
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('admin.slug')</label>
                                <input type="text" name="slug" class="form-control" placeholder="@lang('admin.slug')" />
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <div class="form-group">
                        <label>@lang('admin.title') <span class="text-danger">*</span></label>
                        <input type="text" name="title" class="form-control" value="{{$order->title}}" placeholder="@lang('admin.title')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.visible_url')</label>
                        <input type="text" name="visible_url" class="form-control" value="{{$order->visible_url}}" placeholder="@lang('admin.visible_url')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.description') <span class="text-danger">*</span></label>
                        <textarea class="form-control" name="description" rows="3" placeholder="@lang('admin.description')">{{$order->description}}</textarea>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.phone_number')</label>
                        <input type="text" name="phone_number" class="form-control" value="{{$order->phone_number}}" placeholder="@lang('admin.phone_number')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.email')</label>
                        <input type="text" name="email" class="form-control" value="{{$order->email}}" placeholder="@lang('admin.email')" />
                    </div>
                    
                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">

                    <div class="form-group">
                        <label>@lang('admin.address')</label>
                        <textarea class="form-control" name="address" rows="3" placeholder="@lang('admin.address')">{{$order->address}}</textarea>
                    </div>
                    
                                            </div>


                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.category') <span class="text-danger">*</span></label>
                                <select title="@lang('admin.select_category')" name="categories[]" class="form-control selectpicker" id="multi-categories" multiple="multiple" data-live-search="true" required="required">
                                    @foreach($categories as $category)
                                    <option class="category-head" value="{{ $category->id }}" data-lang="{{ $category->language }}" data-content="[{{$array_data['language_code'][$category->language]}}] {{$category->title}}" @php if(in_array($category->id, $order_categories)) { echo ' selected'; } @endphp></option>

                                    @foreach($category->children as $submenu)
                                    <option class="sub-category-head" data-lang="{{ $submenu->language }}" data-content="{{$submenu->title}}" value="{{ $submenu->id }}" @php if(in_array($submenu->id, $order_categories)) { echo ' selected'; } @endphp></option>

                                    @endforeach

                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <script>
                        $('#multi-categories').on('changed.bs.select', function(e) {
                            var value = $('option:selected', this).attr('data-lang');

                            var selectedOptions = jQuery('#multi-categories option:selected');

                            if (selectedOptions.length > 0) {
                                $("#multi-categories [data-lang!='" + value + "']").attr("disabled", "true");
                                $('#multi-categories').selectpicker('refresh');
                            } else {
                                $("#multi-categories [data-lang!='" + value + "']").removeAttr("disabled", "true");
                                $('#multi-categories').selectpicker('refresh');
                            }
                        });
                        </script>

                        <div class="col-md-4">

                            <div class="form-group">
                                <label>@lang('admin.city_country')</label>
                                <select title="@lang('admin.select_location')" name="locations" class="form-control selectpicker" id="locations" data-live-search="true">
                                    @foreach($locations as $location)
                                    <option class="category-head" value="{{ $location->id }}" data-content="[{{$array_data['language_code'][$location->language]}}] {{$location->title}}" {{ old('locations') == $location->id ? 'selected' : '' }}></option>

                                    @foreach($location->children as $submenu)
                                    <option class="sub-category-head" value="{{ $submenu->id }}" data-content="{{$submenu->title}}" {{ old('locations') == $submenu->id ? 'selected' : '' }}></option>

                                    @endforeach

                                    @endforeach
                                </select>
                            </div>

                        </div>

                    </div>
                    <!-- /.row -->

                    <script>
                    // Openlayers Map Functions
                    $(document).ready(function() {
                        "use strict";

                        if (document.getElementById("map")) {

                            var map_data = document.getElementById("map");
                            var map_lat = parseFloat(map_data.getAttribute("data-lat"));
                            var map_lon = parseFloat(map_data.getAttribute("data-lon"));
                            var map_zoom = parseFloat(map_data.getAttribute("data-zoom"));

                            var attribution = new ol.control.Attribution({
                                collapsible: false
                            });

                            var map = new ol.Map({
                                controls: ol.control.defaults({
                                    attribution: false
                                }).extend([attribution]),
                                layers: [
                                    new ol.layer.Tile({
                                        source: new ol.source.OSM({
                                            url: 'https://tile.openstreetmap.org/{z}/{x}/{y}.png',
                                            maxZoom: 18
                                        })
                                    })
                                ],
                                target: 'map',
                                view: new ol.View({
                                    center: ol.proj.fromLonLat([map_lon, map_lat]),
                                    maxZoom: 18,
                                    zoom: map_zoom,
                                })
                            });

                            var layer = new ol.layer.Vector({
                                source: new ol.source.Vector({
                                    features: [
                                        new ol.Feature({
                                            geometry: new ol.geom.Point(ol.proj.fromLonLat([map_lon, map_lat]))
                                        })
                                    ]
                                })
                            });

                            layer.set('name', 'map_marker');
                            map.addLayer(layer);

                            map.on('click', e => {
                                var point = map.getCoordinateFromPixel(e.pixel);
                                var lonLat = ol.proj.toLonLat(point);
                                var zoom = map.getView().getZoom();

                                var layer = new ol.layer.Vector({
                                    source: new ol.source.Vector({
                                        features: [
                                            new ol.Feature({
                                                geometry: new ol.geom.Point(ol.proj.fromLonLat([lonLat[0], lonLat[1]]))
                                            })
                                        ]
                                    })
                                });

                                map.getLayers().forEach(layer => {
                                    if (layer.get('name') && layer.get('name') == 'map_marker') {
                                        map.removeLayer(layer)
                                    }
                                });

                                layer.set('name', 'map_marker');
                                map.addLayer(layer);

                                $('#map_lon').val(lonLat[0]);
                                $('#map_lat').val(lonLat[1]);
                                $('#map_zoom').val(zoom);
                            })


                        }
                    });
                    </script>

   <!-- row -->
                    <div class="row">

                        <div class="col-md-12">

                            <div id="popup" class="shadow map-corner">
                                <div id="popup-content"></div>
                            </div>
                            <div id="map" data-lat="{{old('map_lat') ?? '43'}}" data-lon="{{old('mal_lon') ?? '23'}}" data-zoom="{{old('map_zoom') ?? '4'}}"></div>

                            <div class="row mt-3 mt-10">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>@lang('admin.map_lat')</label>
                                        <input type="text" name="map_lat" id="map_lat" class="form-control" value="{{old('map_lat')}}" placeholder="@lang('admin.map_lat')" />
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>@lang('admin.map_lon')</label>
                                        <input type="text" name="map_lon" id="map_lon" class="form-control" value="{{old('map_lon')}}" placeholder="@lang('admin.map_lon')" />
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>@lang('admin.map_zoom')</label>
                                        <input type="text" name="map_zoom" id="map_zoom" class="form-control" value="{{old('map_zoom')}}" placeholder="@lang('admin.map_zoom')" />
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.page_views') <span class="text-danger">*</span></label>
                                <input type="text" name="page_views" class="form-control" value="0" placeholder="@lang('admin.page_views')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.clicks') <span class="text-danger">*</span></label>
                                <input type="text" name="clicks" class="form-control" value="0" placeholder="@lang('admin.clicks')" />
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.featured_category')</label><br />
                                <input type="checkbox" name="featured_category" {{ $order->featured_category == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.featured_home')</label><br />
                                <input type="checkbox" name="featured_home" {{ $order->featured_home == 1 ? 'checked' : '' }}>
                            </div>
                        </div>


                    </div>
                    <!-- /.row -->

                    <div class="form-group">
                        <label>@lang('admin.hidden_content')</label>
                        <textarea class="textarea textarea-style" name="hidden_content" placeholder="@lang('admin.hidden_content')">{{old('hidden_content')}}</textarea>
                    </div>

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.images')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <a href="{{ asset('images/submissions/'.$order->image.'') }}" data-toggle="lightbox"><img src="{{ asset('images/submissions/'.$order->image.'') }}" class="img-responsive site-icon"></a>
                                <label>@lang('admin.site_icon')</label><br />
                                <label class="btn btn-outline btn-sm" id="browse-color-image">@lang('admin.browse')<input type="file" name="different_image" id="import-file-select" class="hidden"></label>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.screenshot')</label><br />
                                <label class="btn btn-outline btn-sm" id="browse-color-screenshot">@lang('admin.browse')<input type="file" name="screenshot" id="import-file-select" class="hidden"></label>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />


                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.bypass_redirection_page')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.active')</label><br />
                                <input type="checkbox" name="bypass_redirect" id="bypass_redirect" {{ $order->bypass_redirect == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.link_type')</label>
                                <select title="@lang('admin.link_type')" name="bypass_type" id="bypass_type" class="form-control selectpicker" data-live-search="true">
                                    @foreach($link_types as $link_id => $bypass_type)
                                    <option value="{{ $link_id }}" {{ $order->bypass_type == $link_id ? ' selected' : '' }}>
                                        {{ $bypass_type }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.bypass_details_page')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.active')</label><br />
                                <input type="checkbox" name="bypass_details" id="bypass_details" {{ $order->bypass_details == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.link_type')</label>
                                <select title="@lang('admin.link_type')" name="bypass_details_type" id="bypass_details_type" class="form-control selectpicker" data-live-search="true">
                                    @foreach($link_types as $link_id => $bypass_details_type)
                                    <option value="{{ $link_id }}" {{ $order->bypass_details_type == $link_id ? ' selected' : '' }}>
                                        {{ $bypass_details_type }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />


                    <!-- row -->
                    <div class="row">
                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.deep_links')</label>
                        </div>
                    </div>
                    <!-- /.row -->

                    @foreach($deep_link_data as $title)

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.title')</label>
                                <input type="text" name="deep_link_{{$loop->iteration}}_title" class="form-control" value="{{$title['title']}}" placeholder="@lang('admin.deep_link') {{$loop->iteration}} @lang('admin.title')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.url')</label>
                                <input type="text" name="deep_link_{{$loop->iteration}}_url" class="form-control" value="{{$title['url']}}" placeholder="@lang('admin.deep_link') {{$loop->iteration}} @lang('admin.url')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.link_type')</label>
                                <select title="@lang('admin.link_type')" name="deep_link_{{$loop->iteration}}_type" class="form-control selectpicker" data-live-search="true">
                                    @foreach($link_types as $link_id => $link_type)
                                    <option value="{{ $link_id }}" {{ $title['type']==$link_id ? ' selected' : '' }}>
                                        {{ $link_type }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    @endforeach

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">
                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.other_contacts')</label>
                        </div>
                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.facebook_url')</label>
                                <input type="text" name="facebook_url" class="form-control" value="{{$other_contacts['facebook_url']['url']}}" placeholder="@lang('admin.facebook_url')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.twitter_url')</label>
                                <input type="text" name="twitter_url" class="form-control" value="{{$other_contacts['twitter_url']['url']}}" placeholder="@lang('admin.twitter_url')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.instagram_url')</label>
                                <input type="text" name="instagram_url" class="form-control" value="{{$other_contacts['instagram_url']['url']}}" placeholder="@lang('admin.instagram_url')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.linkedin_url')</label>
                                <input type="text" name="linkedin_url" class="form-control" value="{{$other_contacts['linkedin_url']['url']}}" placeholder="@lang('admin.linkedin_url')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.whatsapp_number')</label>
                                <input type="text" name="whatsapp_number" class="form-control" value="{{$other_contacts['whatsapp_number']['number']}}" placeholder="@lang('admin.whatsapp_number')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.telegram_url')</label>
                                <input type="text" name="telegram_url" class="form-control" value="{{$other_contacts['telegram_url']['url']}}" placeholder="@lang('admin.telegram_url')" />
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.seo_settings')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <div class="form-group">
                        <label>@lang('admin.custom_title')</label>
                        <input type="text" name="custom_title" class="form-control" placeholder="@lang('admin.custom_title')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.custom_description')</label>
                        <textarea class="form-control" name="custom_description" rows="3" placeholder="@lang('admin.custom_description')"></textarea>
                    </div>

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.other_settings')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">


                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.expire_time')</label>
                                <input type="text" name="expire_at" id="expire_at" value="@isset($new_expire_date){{$new_expire_date}}@else{{$expire_date}}@endif" class="form-control" placeholder="@lang('admin.expire_time')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.votes')</label>
                                <input type="text" name="votes" id="votes" class="form-control" value="{{old('votes') ?? '0.00'}}" placeholder="@lang('admin.votes')" />
                            </div>
                        </div>


                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.total_votes')</label>
                                <input type="text" name="total_votes" id="total_votes" class="form-control" value="{{old('total_votes') ?? 0}}" placeholder="@lang('admin.total_votes')" />
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    @isset($new_expire_date)
                    <div class="alert alert-subscription-details">
                        <p><sup>1</sup> @lang('admin.submission_time'): <b>{{\Carbon\Carbon::parse($order->order_time)->translatedFormat('F d, Y H:i:s')}}</b></p>
                        <p><sup>2</sup> @lang('admin.expire_time'): <b>{{\Carbon\Carbon::parse($expire_date)->translatedFormat('F d, Y H:i:s')}}</b></p>
                        <p><sup>3</sup> @lang('admin.package_extend_message', ['time' => $additional_time]) @if(count($subscription_payments)>='2') @lang('admin.additional_payments_message', ['payments' => count($subscription_payments)-1]) @endif</p>
                        <p><sup>4</sup> @lang('admin.new_expire_date', ['time' => \Carbon\Carbon::parse($new_expire_date)->translatedFormat('F d, Y H:i:s')])</p>
                    </div>
                    @endif

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.enabled')</label><br />
                                <input type="checkbox" name="enabled" id="enabled" @if(!old() || old('enabled')=='on' ) checked="checked" @endif }}>
                            </div>
                        </div>

                        <div class="col-md-4">

                            <div class="form-group">
                                <label>@lang('admin.show_badge')</label><br />
                                <input type="checkbox" name="badge" id="badge" {{ old('badge') == "on" ? 'checked' : '' }}>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

            </div>
            <!-- /.box-body -->

            <div class="box-footer">
                <button type="submit" class="btn btn-primary">@lang('admin.submit')</button>
            </div>

            </form>
            <!-- /.form -->

        </div>
        <!-- /.general form elements -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection