{!!$settings['after_head_tag']!!}

<div class="header-container">
    <div class="container">
        <header class="site-header">
            <div class="row">
                <div class="col-6">
                    @if ($settings['use_text_logo'] == '0')
                    <h1 class="image-logo">
                        <a href="{{ asset($language_prefix) }}"><img src="{{ asset('/images/logo.png') }}" alt="{{$settings['site_title']}}"></a>
                    </h1>
                    @else
                    <h1 class="text-logo">
                        <a href="{{ asset($language_prefix) }}">
                            {{$settings['site_title']}}</a>
                    </h1>
                    @endif
                </div>
                <div class="col-6 d-flex justify-content-end align-items-center">
                    <div class="header-icons">
                        @auth
                        <a href="{{ asset($language_prefix.'member-area') }}"><i class="icon-user"></i></a>
                        @else
                        <a href="{{ asset($language_prefix.'member-area/login') }}"><i class="icon-sign-in"></i></a>
                        @endauth
                        @if (!empty($settings['facebook_page']))<a href="{{$settings['facebook_page']}}" target="_blank"><i class="icon-facebook"></i></a>@endif
                        @if (!empty($settings['twitter_account']))<a href="https://www.twitter.com/{{$settings['twitter_account']}}" target="_blank"><i class="icon-twitter"></i></a>@endif
                        @if ($settings['show_random_link'] == '1')<a href="{{ asset($language_prefix.$settings['detail_base'].'/random') }}"><i class="icon-random"></i></a>@endif
                        @if (!empty($settings['show_rss_feed']))<a href="{{ asset($language_prefix.'rss') }}" target="_blank"><i class="icon-rss"></i></a>@endif
                        @if ($settings['hide_language_selector'] == '0')
                        <div class="btn-group">
                            <button class="btn dropdown-toggle lang-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <span class="lang-flag fi fi-{{$language_icon_code}}"></span><i class="icon-angle-down lang-down-icon"></i>
                            </button>
                            <div class="dropdown-menu mt-1">
                                @foreach ($languages as $language)
                                @if ($language->hidden == '0')
                                <a class="dropdown-item py-1 px-2 px-md-3 text-black" href="{{ asset($menu_language_prefix[$language->id]) }}"><span class="fi fi-{{$language->icon}}"></span> {{$language->language}}</a>
                                @endif
                                @endforeach
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </header>
    </div>
</div>

@if ($settings['navbar_type'] == '1')
<div class="nav-scroller bg-body shadow-sm">
    <div class="container">
        <nav class="nav nav-underline">
            <a class="nav-link ps-0" aria-current="page" href="{{ asset($language_prefix) }}">@lang('general.homepage')</a>
            @if ($settings['enable_submission_form'] == '1')<a class="nav-link" href="{{ asset($language_prefix.'member-area/packages') }}">@lang('general.submit_link')</a>@endif
            <a class="nav-link" href="{{ asset($language_prefix.$settings['latest_links_slug']) }}">@lang('general.latest_links')</a>
            <a class="nav-link" href="{{ asset($language_prefix.$settings['popular_links_slug']) }}">@lang('general.popular_links')</a>
            @if ($settings['allow_user_favorites'] == '1')<a class="nav-link" href="{{ asset($language_prefix.$settings['favorites_slug']) }}">@lang('general.favorites')</a>@endif
            @if ($settings['allow_user_history'] == '1')<a class="nav-link" href="{{ asset($language_prefix.$settings['history_slug']) }}">@lang('general.history')</a>@endif
            @if ($settings['show_articles_in_header'] == '1')<a class="nav-link" href="{{ asset($language_prefix.$settings['all_articles_slug']) }}">@lang('general.articles')</a>@endif
            @foreach ($pages as $page)
            @if ($page->navbar == '1')
            <a class="nav-link" href="{{ asset($language_prefix.$settings['page_base']) }}/{{ $page->slug }}">{{ $page->title }}</a>
            @endif
            @endforeach
            @foreach ($partners as $partner)
            @if ($partner->navbar == '1')
            <a class="nav-link" href="{{ $partner->url }}" target="_blank" {!! $link_types[$partner['link_type']] !!}>{{ $partner->title }}</a>
            @endif
            @endforeach
            <a class="nav-link" href="{{ asset($language_prefix.$settings['contact_slug']) }}">@lang('general.contact')</a>
            @auth
            <a class="nav-link" href="{{ URL::to($language_prefix.'member-area/logout') }}">@lang('general.logout')</a>
            @endauth
        </nav>
    </div>
</div>
@else
<div class="navbar navbar-expand-md navbar-new navbar-light bg-body shadow-sm">
    <div class="container">
        <div class="d-flex flex-row">
            <a class="nav-link pe-2" href="{{ asset($language_prefix) }}">@lang('general.homepage')</a>
        </div>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarCollapse">
            <ul class="navbar-nav">
                @if ($settings['enable_submission_form'] == '1')
                <li class="nav-item">
                    <a class="nav-link" href="{{ asset($language_prefix.'member-area/packages') }}">@lang('general.submit_link')</a>
                </li>
                @endif
                <li class="nav-item">
                    <a class="nav-link" href="{{ asset($language_prefix.$settings['latest_links_slug']) }}">@lang('general.latest_links')</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ asset($language_prefix.$settings['popular_links_slug']) }}">@lang('general.popular_links')</a>
                </li>
                @if ($settings['allow_user_favorites'] == '1')
                <li class="nav-item">
                    <a class="nav-link" href="{{ asset($language_prefix.$settings['favorites_slug']) }}">@lang('general.favorites')</a>
                </li>
                @endif
                @if ($settings['allow_user_history'] == '1')
                <li class="nav-item">
                    <a class="nav-link" href="{{ asset($language_prefix.$settings['history_slug']) }}">@lang('general.history')</a>
                </li>
                @endif
                <li class="nav-item">
                    @if ($settings['show_articles_in_header'] == '1')<a class="nav-link" href="{{ asset($language_prefix.$settings['all_articles_slug']) }}">@lang('general.articles')</a>@endif
                </li>
                @foreach ($pages as $page)
                @if ($page->navbar == '1')
                <li class="nav-item">
                    <a class="nav-link" href="{{ asset($language_prefix.$settings['page_base']) }}/{{ $page->slug }}">{{ $page->title }}</a>
                </li>
                @endif
                @endforeach
                @foreach ($partners as $partner)
                @if ($partner->navbar == '1')
                <li class="nav-item">
                    <a class="nav-link" href="{{ $partner->url }}" target="_blank" {!! $link_types[$partner['link_type']] !!}>{{ $partner->title }}</a>
                </li>
                @endif
                @endforeach
                <li class="nav-item">
                    <a class="nav-link" href="{{ asset($language_prefix.$settings['contact_slug']) }}">@lang('general.contact')</a>
                </li>
                @auth
                <li class="nav-item">
                    <a class="nav-link" href="{{ URL::to($language_prefix.'member-area/logout') }}">@lang('general.logout')</a>
                </li>
                @endauth
            </ul>
        </div>
    </div>
</div>
@endif

<div id="notificationsContainer"></div>

@if(Session::has('message'))
<script>
    var notify = new notificationManager({
        container: $('#notificationsContainer')
    });

    var anim = true;
    var auto = true;

    notify.setPosition('topright');

    notify.addNotification({
        message: "{{ Session::get('message') }}"
        , animate: anim
        , autoRemove: auto
        , backgroundColor: "#92c66c"
        , progressColor: "#ffffff"
    });

</script>
@endif

@if (!empty($ad[1]))
@php echo '<div class="container text-center mt-3">'.$ad[1].'</div>'; @endphp
@endif
