@extends('rtl-frontend::page')

@section('content')

<!-- Container -->
<main class="container links mt-3">

    <!-- Grid Row -->
    <div class="row">

        <!-- Grid Column -->
        <div class="col-md-7">

            @if(!empty($ad[4]))<div class="mb-3 text-center">{!! $ad[4] !!}</div>@endif

            <!-- Search Box -->
            @include('rtl-frontend::inc.partials', ['type' => '1'])
            <!-- /Search Box -->

            @if ($settings['breadcrumbs'] == '1')
            <!-- Breadcrumbs -->
            <div class="breadcrumbs mb-3">
                <a href="{{ asset($language_prefix) }}">@lang('general.homepage')</a> <span class="sep">›</span> <a href="{{ asset($language_prefix.$settings['all_articles_slug']) }}">@lang('general.articles')</a> <span class="sep">›</span> <a href="{{url()->current()}}">{{$article_query->title}}</a>
            </div>

            @if ($settings['schema_breadcrumbs'] == '1')
            {!! $breadcrumb_schema_data->toScript() !!}
            @endif
            <!-- /Breadcrumbs -->
            @endif

            <!-- Page Content -->
            <div class="shadow-sm p-2 bg-white rounded mb-3">
                <div class="p-1">
                    <h2 class="article-title">{{$article_query->title}}@auth @if (auth()->user()->user_type == '1') <a href="{{ asset(env('ADMIN_URL').'/articles/'.$article_query->id.'/edit') }}" target="_blank"><sup class="edit">[@lang('general.edit')]</sup></a> @endif @endauth</h2>
                    <h3 class="article-description">{!! $article_query->description !!}</h3>
                    <span class="article-date">{{\Carbon\Carbon::parse($article_query->created_at)->translatedFormat('F d, Y H:i')}}</span>

                    <div class="row social-media">
                        <div class="col text-center p-2 facebook"><a onclick="sm_share('https://www.facebook.com/sharer/sharer.php?u={{url()->current()}}','Facebook','600','300');" href="javascript:void(0);"><i class="icon-facebook ml-2"></i> <span class="d-none d-lg-inline-block">Facebook</span></a></div>
                        <div class="col text-center p-2 twitter"><a onclick="sm_share('http://twitter.com/share?text={{str_replace("'", "\'", $article_query->title)}}&url={{url()->current()}}','Twitter','600','300');" href="javascript:void(0);"><i class="icon-twitter ml-2"></i> <span class="d-none d-lg-inline-block">Twitter</span></a></div>
                        <div class="col text-center p-2 linkedin"><a onclick="sm_share('https://www.linkedin.com/sharing/share-offsite/?url={{url()->current()}}','Linkedin','600','300');" href="javascript:void(0);"><i class="icon-linkedin ml-2"></i> <span class="d-none d-lg-inline-block">Linkedin</span></a></div>
                        <div class="col text-center p-2 whatsapp"><a onclick="sm_share('https://api.whatsapp.com/send?text={{str_replace("'", "\'", $article_query->title)}} {{url()->current()}}','WhatsApp','700','650');" href="javascript:void(0);"><i class="icon-whatsapp ml-2"></i> <span class="d-none d-lg-inline-block">WhatsApp</span></a></div>
                        <div class="col text-center p-2 email"><a href="mailto:?subject={{$article_query->title}}&amp;body={{url()->current()}}"><i class="icon-envelope ml-2"></i> <span class="d-none d-lg-inline-block">E-mail</span></a></div>
                    </div>

                    <img src="{{ asset('images/pixel.png') }}" data-src="{{ asset('images') }}/articles/{{ $article_query->image}}" class="img-fluid mb-2 lazy" alt="{{ $article_query->title }}">

                    {!! $article_query->details !!}
                </div>
            </div>
            <!-- /Page Content -->

            <div class="d-flex mb-3">
                <div class="my-auto ms-auto">
                    <h2 class="h2-title m-0">@lang('general.user_comments') ({{ count($news_comments) }})</h2>
                </div>
                <div class="my-auto"><a href="#" class="btn add-comment text-white float-end mt-0">@lang('general.add_comment')</a></div>
            </div>

            <div class="shadow-sm p-2 bg-white rounded pb-1 mb-3">
                <div class="m-1">

                    <div class="user-reviews">

                        @if ($news_comments->isEmpty())
                        <div class="alert alert-warning show mb-2" role="alert">@lang('general.no_comments_yet')</div>
                        @endif

                        @foreach ($news_comments as $comment)

                        <div class="review mt-2 @if ($loop->first) border-0 @endif pt-0">
                            <p class="title @if ($loop->first) pt-0 mt-0 @endif">"{{{$comment->title}}}"</p>
                            <div class="row">
                                <div class="col-6">
                                    <p class="name">{{{$comment->name}}}</p>
                                </div>
                            </div>
                            <p class="date" data-bs-toggle="tooltip" data-bs-placement="top" title="{{\Carbon\Carbon::parse($comment->created_at)->translatedFormat('F d, Y H:i')}}">
                                {{ \Carbon\Carbon::parse($comment->created_at)->diffForHumans() }}</p>

                            <p class="comment">{{{$comment->comment}}}</p>
                        </div>

                        @endforeach

                        <div class="comment-box" id="comment-section" data-fill-all-fields="@lang('general.fill_all_fields')">

                            <form id="comment-form">

                                <div class="review-title mt-3 mb-2" id="review-title">
                                    @lang('general.add_comment')</div>

                                <input type="hidden" name="content_id" value="{{$article_query->id}}" />
                                <input type="hidden" name="type" value="2" />

                                <div class="mb-3">
                                    <label for="name">@lang('general.your_name'): <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control mt-2" id="name" name="name" required>
                                </div>

                                <div class="mb-3">
                                    <label for="title">@lang('general.comment_title'): <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control mt-2" id="title" name="title" required>
                                </div>

                                <div class="mb-3">
                                    <label for="email">@lang('general.your_email'): <span class="text-danger">*</span></label>
                                    <input type="email" class="form-control mt-2" id="email" name="email" required>
                                    <small id="emailHelp" class="form-text text-muted">@lang('general.email_notification')</small>
                                </div>

                                <div class="mb-3">
                                    <label for="comment">@lang('general.your_comment'): <span class="text-danger">*</span></label>
                                    <textarea class="form-control mt-2" rows="5" id="comment" name="comment" maxlength="1000" required></textarea>
                                </div>

                            </form>

                            <button type="submit" class="btn m-0 comment-button text-white" onclick="form_control()">@lang('general.submit')</button>

                            <div id="comment_result">
                                <div class="alert alert-warning show mt-3 mb-2" role="alert">
                                    @lang('general.comment_rules')</div>
                            </div>

                        </div>
                    </div>

                </div>
            </div>

            @if(!empty($ad[3]))<div class="mb-3 text-center">{!! $ad[3] !!}</div>@endif

        </div>
        <!-- /Grid Column -->

        <!-- Grid Column -->
        <div class="col-md-2">
            <!-- Articles -->
            <div class="row articles sticky-top sticky-top-15">
                @foreach ($articles as $article)
                <div class="col-12 mb-3">
                    <div class="bg-white shadow-sm"><a href="{{ asset($language_prefix.$settings['article_base']) }}/{{ $article->slug }}"><img src="{{ asset('images/pixel.png') }}" data-src="{{ asset('images') }}/articles/{{ $article->image}}" alt="{{ $article->title }}" class="img-fluid lazy">
                            <div class="p-2 mx-1">
                                <h3>{{ $article->title}}</h3>
                            </div>
                        </a></div>
                </div>
                @endforeach
            </div>
            <!-- Articles -->
        </div>
        <!-- /Grid Column -->

        <!-- Grid Column -->
        <div class="col-md-3 text-center mb-3">
            @if ($settings['sticky_ads_right_column'] == '1')<div class="sticky-top sticky-top-15">@endif
                @if(!empty($ad[5]))<div class="mb-3">{!! $ad[5] !!}</div>@endif
                @if ($settings['sticky_ads_right_column'] == '1')</div>@endif
        </div>
        <!-- /Grid Column -->

    </div>
    <!-- /Grid row -->

</main>
<!-- /Container -->

@endsection