@if($type == '1')

<div class="col-12 mb-3">
    <form method="post" action="{{ asset($language_prefix.'search') }}" class="d-flex shadow-sm p-2 bg-white rounded">
        {{ csrf_field() }}
        <input class="form-control search-form me-2 pe-1" @if ($settings['enable_live_ajax_search']=='1' ) id="search-form" @endif name="term" type="search" placeholder="@lang('general.search_links')" aria-label="@lang('general.search_links')">
        <button class="btn search-btn" type="submit"> <i class="icon-search"></i></button>
    </form>
</div>

@endif

@if($type == '2')

<!-- Articles -->
<div class="row articles">
    @if ($settings['scrollable_articles_home_page'] == '1')<div class="row flex-nowrap p-0 m-0">@endif
        @foreach ($articles as $article)
        <div class="col-md-3 @if ($settings['scrollable_articles_home_page'] == '1')col-7 @else col-6 @endif mb-3">
            <div class="bg-white shadow-sm rounded">
                <a href="{{ asset($language_prefix.$settings['article_base']) }}/{{ $article->slug }}"><img src="{{ asset('images') }}/cache/{{ $article->image}}" width="770" height="450" alt="{{ $article->title }}" class="img-fluid rounded-top">
                    <div class="p-2 mx-1">
                        <h3 class="">{{ $article->title}}</h3>
                    </div>
                </a>
            </div>
        </div>
        @endforeach
        @if ($settings['scrollable_articles_home_page'] == '1')
    </div>@endif
</div>
<!-- /Articles -->

@endif

@if($type == '3')

<ul class="list-unstyled p-1">
    <li><span class="user-name">@lang('general.hello') <strong>{{$member->name}}!</strong></span></li>
    <li><a href="{{ URL::to($language_prefix.'member-area/my-links') }}">@lang('general.my_links')<i class="icon-link float-start"></i></a></li>
    @if ($settings['enable_submission_form'] == '1')
    <li><a href="{{ URL::to($language_prefix.'member-area/packages') }}">@lang('general.submit_link')<i class="icon-plus float-start"></i></a></li>
    @endif
    <li><a href="{{ URL::to($language_prefix.'member-area/my-orders') }}">@lang('general.my_orders')<i class="icon-shopping-cart float-start"></i></a></li>
    <li><a href="{{ URL::to($language_prefix.'member-area/my-account') }}">@lang('general.my_account')<i class="icon-user float-start"></i></a></li>
    <li><a href="{{ URL::to($language_prefix.'member-area/logout') }}">@lang('general.logout')<i class="icon-sign-out float-start"></i></a></li>
</ul>

@endif