@extends('rtl-frontend::page')

@section('content')

<!-- Container -->
<main class="container">

    <!-- Grid Row -->
    <div class="row member-area mt-3">

        <div class="col-md-3 menu">

            <div class="bg-white shadow-sm rounded p-2 pb-0">
                <!-- Left Column -->
                @include('rtl-frontend::inc.partials', ['type' => '3'])
                <!-- /Left Column -->
            </div>

        </div>

        <div class="col-md-9">

            <div class="row row-cols-1 row-cols-md-3 pb-0 text-center">

                @foreach ($packages as $package)

                <div class="col">
                    <div class="card mb-3 rounded-3 shadow-sm">
                        <div class="card-header py-3">
                            <h4 class="my-0 fw-bold h6">{{ $package->title }}</h4>
                        </div>
                        <div class="card-body">
                            <h1 class="card-title pricing-card-title h5">@if($package->price=='0.00')@lang('general.free') @else{{ $settings['payment_currency_symbol'] }}{{$package->price}}@endif @if($package->real_price!='') <del>{{$package->real_price}}</del>@endif / {{$durations[$package->duration]}}</h1>
                            <div class="mt-3 mb-3 h-100">
                                {!! nl2br(e($package->description)) !!}
                            </div>
                            <a href="{{ asset($language_prefix."member-area/package/$package->id") }}" class="w-100 btn btn-lg get-started">@lang('general.get_started')</a>
                        </div>
                    </div>
                </div>

                @endforeach

            </div>

        </div>

    </div>
    <!-- /Grid row -->

</main>
<!-- /Container -->

@endsection