<?php

use Illuminate\Support\Facades\Route;

$settings = DB::table('settings')->whereIn('name', ['site_language', 'root_language'])->pluck('value', 'name');
$languages = DB::table('translations')->get();

foreach ($languages as $language) {
    $lang_codes[] = $language->code;
    $lang_id[$language->code] = $language->id;
}

if (in_array(request()->segment(1), $lang_codes)) {
    $site_language_prefix = request()->segment(1);
    $site_language_code = request()->segment(1);
} else {
    $site_language_prefix = null;
    $site_language_code = $settings['site_language'];
}

$language_id = $lang_id[$site_language_code];

Route::group(['prefix' => $site_language_prefix, 'middleware' => ['language:' . $site_language_code . '']], function () use ($language_id) {
    $settings = DB::table('settings')->where('language', $language_id)->pluck('value', 'name');
    Route::get('/', 'App\Http\Controllers\SiteController@index');
    Route::get("/$settings[category_base]/{parent_slug}/{slug}", 'App\Http\Controllers\SiteController@category');
    Route::get("/$settings[category_base]/{slug}", 'App\Http\Controllers\SiteController@category');
    Route::get("/$settings[location_base]/{parent_slug}/{slug}", 'App\Http\Controllers\SiteController@location');
    Route::get("/$settings[location_base]/{slug}", 'App\Http\Controllers\SiteController@location');
    Route::get("/$settings[article_base]/{slug}", 'App\Http\Controllers\SiteController@article');
    Route::get("/$settings[detail_base]/random", 'App\Http\Controllers\SiteController@random');
    Route::get("/$settings[redirect_base]/{slug}", 'App\Http\Controllers\SiteController@redirect');
    Route::get("/$settings[tag_base]/{slug}", 'App\Http\Controllers\SiteController@tag');
    Route::get("/$settings[detail_base]/{slug}", 'App\Http\Controllers\SiteController@detail');
    Route::get("/$settings[page_base]/{slug}", 'App\Http\Controllers\SiteController@page');
    Route::match(array('GET', 'POST'), '/search', 'App\Http\Controllers\SiteController@search');
    Route::get("/$settings[contact_slug]", 'App\Http\Controllers\SiteController@contact');
    Route::get("/$settings[latest_links_slug]", 'App\Http\Controllers\SiteController@latest_links');
    Route::get("/$settings[popular_links_slug]", 'App\Http\Controllers\SiteController@popular_links');
    Route::get("/$settings[all_articles_slug]", 'App\Http\Controllers\SiteController@all_articles');
    Route::get('/member-area/login', 'App\Http\Controllers\FrontendMemberController@login')->name('member-login');
    Route::post('/member-area/login', 'App\Http\Controllers\FrontendMemberController@dologin');
    Route::get('/member-area/register', 'App\Http\Controllers\FrontendMemberController@register');
    Route::post('/member-area/register', 'App\Http\Controllers\FrontendMemberController@doregister');
    Route::get('/member-area/paypal-order', 'App\Http\Controllers\PaymentController@paypal_order');
    Route::get('/member-area/paypal-subscription', 'App\Http\Controllers\PaymentController@paypal_subscription_process');
    Route::get('/member-area/verify-email/{slug}', 'App\Http\Controllers\FrontendMemberController@doverify');
    Route::get('/member-area/password-request/{slug}', 'App\Http\Controllers\FrontendMemberController@passwordrequest');
    Route::get('/member-area/password-reset', 'App\Http\Controllers\FrontendMemberController@passwordreset');
    Route::post('/member-area/password-reset', 'App\Http\Controllers\FrontendMemberController@dopasswordreset');
    Route::get('/rss', 'App\Http\Controllers\RSSController@links');
    Route::get('/article-rss', 'App\Http\Controllers\RSSController@articles');
    Route::post('/contact-form', 'App\Http\Controllers\ContactFormController@store');
    Route::post('/report-link', 'App\Http\Controllers\LinkReportController@store');
    Route::post('/comment', 'App\Http\Controllers\FrontendCommentController@store');
    Route::get('/link-redirect/{id}', 'App\Http\Controllers\SiteController@link_redirect');
    Route::get('/widget/{id}', 'App\Http\Controllers\SiteController@widget');
    Route::post('/json-search', 'App\Http\Controllers\SiteController@json_search');
    Route::post('/vote/{id}', 'App\Http\Controllers\VoteController@show');
    Route::get("/$settings[favorites_slug]", 'App\Http\Controllers\SiteController@favorites');
    Route::get("/$settings[history_slug]", 'App\Http\Controllers\SiteController@browse_history');
});

Route::group(['prefix' => $site_language_prefix . '/member-area', 'middleware' => ['language:' . $site_language_code . '', 'auth', 'isMember']], function () {
    Route::get('/', 'App\Http\Controllers\FrontendMemberController@index');
    Route::get('/packages', 'App\Http\Controllers\FrontendMemberController@packages');
    Route::get('/my-account', 'App\Http\Controllers\FrontendMemberController@myaccount');
    Route::post('/my-account', 'App\Http\Controllers\FrontendMemberController@domyaccount');
    Route::get('/my-links', 'App\Http\Controllers\FrontendMemberController@my_links');
    Route::get('/my-orders', 'App\Http\Controllers\FrontendMemberController@my_orders');
    Route::post('submit-link', 'App\Http\Controllers\FrontendMemberController@submit_link');
    Route::get('/package/{id}', 'App\Http\Controllers\FrontendMemberController@package');
    Route::get('/order/{id}', 'App\Http\Controllers\FrontendMemberController@order_details');
    Route::get('/edit/{id}', 'App\Http\Controllers\FrontendMemberController@link_details');
    Route::post('/edit/{id}', 'App\Http\Controllers\FrontendMemberController@link_update');
    Route::get('/logout', 'App\Http\Controllers\FrontendMemberController@dologout');
    Route::get('/payment-notification/{id}', 'App\Http\Controllers\FrontendMemberController@payment_notification');
    Route::post('/payment-notification/{id}', 'App\Http\Controllers\PaymentController@send_payment_notification');
    Route::get('/stripe-payment/{id}', 'App\Http\Controllers\FrontendMemberController@stripe_form');
    Route::post('/stripe-payment/{id}', 'App\Http\Controllers\PaymentController@stripe_order');
    Route::get('/renew-package/{id}', 'App\Http\Controllers\FrontendMemberController@renew_package');
    Route::get('/renew/{id}/{method}', 'App\Http\Controllers\PaymentController@renewal');
});
Route::get('/sitemaps.xml', 'App\Http\Controllers\SitemapController@index');
Route::get("/sitemap/{slug}.xml", 'App\Http\Controllers\SitemapController@sitemap');
Route::get('/cronjob/{slug}', 'App\Http\Controllers\CronjobController@index');
Route::post($site_language_prefix . '/api/paypal-webhook/{slug}', 'App\Http\Controllers\PaymentController@paypal_webhook');
Route::group(['prefix' => env('ADMIN_URL'), 'middleware' => ['auth', 'isAdmin']], function () {
    Route::match(array('GET', 'POST'), '/categories/create_categories_bulk', 'App\Http\Controllers\CategoryController@bulk');
    Route::match(array('GET', 'POST'), '/links/create_links_bulk', 'App\Http\Controllers\LinkController@bulk');
    Route::get('/main_categories/{id}', 'App\Http\Controllers\CategoryController@main_categories');
    Route::get('/sub_categories/{id}', 'App\Http\Controllers\CategoryController@sub_categories');
    Route::get('/countries/{id}', 'App\Http\Controllers\LocationController@countries');
    Route::get('/cities/{id}', 'App\Http\Controllers\LocationController@cities');
    Route::get('/page_list/{id}', 'App\Http\Controllers\PageController@page_list');
    Route::get('/partner_list/{id}', 'App\Http\Controllers\PartnerController@partner_list');
    Route::get('/seo_settings/{id}', 'App\Http\Controllers\SettingController@seo_settings_language');
    Route::post('/seo_settings/{id}', 'App\Http\Controllers\SettingController@seo_settings_update');
    Route::get('/pwa_settings', 'App\Http\Controllers\SettingController@pwa_settings');
    Route::post('/pwa_settings', 'App\Http\Controllers\SettingController@pwa_settings_update');
    Route::resource('/links', 'App\Http\Controllers\LinkController');
    Route::resource('/categories', 'App\Http\Controllers\CategoryController');
    Route::resource('/locations', 'App\Http\Controllers\LocationController');
    Route::resource('/articles', 'App\Http\Controllers\ArticleController');
    Route::resource('/submissions', 'App\Http\Controllers\SubmissionController');
    Route::resource('/comments', 'App\Http\Controllers\CommentController');
    Route::resource('/partners', 'App\Http\Controllers\PartnerController');
    Route::resource('/pages', 'App\Http\Controllers\PageController');
    Route::resource('/members', 'App\Http\Controllers\MemberController');
    Route::resource('/ads', 'App\Http\Controllers\AdController');
    Route::resource('/orders', 'App\Http\Controllers\OrderController');
    Route::resource('/translations', 'App\Http\Controllers\TranslationController');
    Route::resource('/packages', 'App\Http\Controllers\PackageController');
    Route::resource('/notifications', 'App\Http\Controllers\NotificationController');
    Route::resource('/bank_accounts', 'App\Http\Controllers\BankController');
    Route::resource('/notifications', 'App\Http\Controllers\NotificationsController');
    Route::resource('/settings', 'App\Http\Controllers\SettingController')->only(['index', 'store']);
    Route::match(array('GET', 'POST'), '/members/send_email/{id}', 'App\Http\Controllers\MemberController@send_email');
    Route::get('/payment_notification/{id}', 'App\Http\Controllers\BankpaymentController@bank_payment');
    Route::resource('/payment_notifications', 'App\Http\Controllers\BankpaymentController');
    Route::get('/seo_settings', 'App\Http\Controllers\SettingController@seo_settings');
    Route::get('/mail_settings', 'App\Http\Controllers\SettingController@mail_settings');
    Route::post('/mail_settings', 'App\Http\Controllers\SettingController@mail_settings_update');
    Route::get('/payment_listing_settings', 'App\Http\Controllers\SettingController@payment_listing_settings');
    Route::post('/payment_listing_settings', 'App\Http\Controllers\SettingController@payment_listing_settings_update');
    Route::get('/search', 'App\Http\Controllers\LinkController@search');
    Route::get('/account_settings', 'App\Http\Controllers\HomeController@accountsettingsform');
    Route::post('/account_settings', 'App\Http\Controllers\HomeController@accountsettings')->name('accountsettings');
    Route::post('/multiple-file-upload/upload', 'App\Http\Controllers\MultipleUploadController@upload')->name('upload');
    Route::post('/multiple-file-upload/delete', 'App\Http\Controllers\MultipleUploadController@delete')->name('delete');
    Route::get('/', 'App\Http\Controllers\LinkController@index');
});

Route::get(env('ADMIN_LOGIN_URL'), 'App\Http\Controllers\Auth\LoginController@showLoginForm')->name('login');
Route::post(env('ADMIN_LOGIN_URL'), 'App\Http\Controllers\Auth\LoginController@login');

Auth::routes([
    'login' => false,
    'register' => false,
    'reset' => true,
    'verify' => false,
]);

Route::get('/' . env('ADMIN_URL') . '/random_key', function () {
    define('AES_256_CBC', 'aes-256-cbc');
    $encryption_key = openssl_random_pseudo_bytes(32);
    $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length(AES_256_CBC));
    $data = substr(str_shuffle("abcdefghijklmnopqrstuvwxyz"), 0, 32);
    return openssl_encrypt($data, AES_256_CBC, $encryption_key, 0, $iv);
})->middleware('auth');