<?php
// Link Directory Pro Update Tool

set_time_limit(0);
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);

$index_file = file_get_contents('index.php');
preg_match('/\$lapp_folder = \'(.*)\';/iUs', htmlentities($index_file), $autoload);
$lapp_folder = $autoload[1];
$lapp_folder[0] == "/" ? $lapp_folder = substr($lapp_folder, 1) : '';

if ( $lapp_folder == '' ) {
    preg_match('/__DIR__.\'\/(.*)\/storage\//iUs', $index_file, $lapp_location);
    $lapp_folder = $lapp_location[1];
}

if ( $lapp_folder == '' ) {
    preg_match('/__DIR__.\'\/(.*)\/vendor\//iUs', $index_file, $lapp_location);
    $lapp_folder = $lapp_location[1];
}

define('LARAVEL_START', microtime(true));
require "$lapp_folder/vendor/autoload.php";
$app = require_once "$lapp_folder/bootstrap/app.php";
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

$process = 0;

use Illuminate\Support\Facades\DB;

$site_settings = DB::table('settings')->get();

foreach ($site_settings as $setting) {
    $settings[$setting->name] = $setting->value;
}

$site_language = DB::table('translations')->where('code', $settings['site_language'])->first();
$translations = DB::table('translations')->where('code', '!=', $settings['site_language'])->get();
$all_languaages = DB::table('translations')->get();


$app_name = env('APP_NAME');
$app_key = env('APP_KEY');
$app_url = env('APP_URL');
$app_purifier = env('APP_PURIFIER');

$admin_url = env('ADMIN_URL');
$app_login_url = env('ADMIN_LOGIN_URL');

$db_connection = env('DB_CONNECTION');
$db_host = env('DB_HOST');
$db_port = env('DB_PORT');
$db_database = env('DB_DATABASE');
$db_username = env('DB_USERNAME');
$db_password = env('DB_PASSWORD');

$mail_driver = env('MAIL_DRIVER');
$mail_host = env('MAIL_HOST');
$mail_port = env('MAIL_PORT');
$mail_username = env('MAIL_USERNAME');
$mail_password = env('MAIL_PASSWORD');
$mail_encryption = env('MAIL_ENCRYPTION');
$mail_from_address = env('MAIL_FROM_ADDRESS');
$mail_from_name = env('MAIL_FROM_NAME');

$PAYPAL_MODE = env('PAYPAL_MODE');
$PAYPAL_SANDBOX_CLIENT_ID = env('PAYPAL_SANDBOX_CLIENT_ID');
$PAYPAL_SANDBOX_CLIENT_SECRET = env('PAYPAL_SANDBOX_CLIENT_SECRET');
$PAYPAL_LIVE_CLIENT_ID = env('PAYPAL_LIVE_CLIENT_ID');
$PAYPAL_LIVE_CLIENT_SECRET = env('PAYPAL_LIVE_CLIENT_SECRET');
$PAYPAL_WEBHOOK_ID = env('PAYPAL_WEBHOOK_ID');
$STRIPE_KEY = env('STRIPE_KEY');
$STRIPE_SECRET = env('STRIPE_SECRET');
$CASHIER_CURRENCY = env('CASHIER_CURRENCY');
$CASHIER_CURRENCY_SYMBOL = env('CASHIER_CURRENCY_SYMBOL');
$COINBASE_API_KEY = env('COINBASE_API_KEY');
$COINBASE_WEBHOOK_SECRET = env('COINBASE_WEBHOOK_SECRET');

if(!is_dir('public_files_d')) {
        
        set_time_limit(0);
file_put_contents("public_files.zip", file_get_contents("https://v13migration.foxart.co/public_files.zip"));
$zip = new ZipArchive;
$zip->open('public_files.zip');
$zip->extractTo(__DIR__ . "/temp");
$zip->close();

unlink('public_files.zip');

if (!file_exists('public_files_d')) {
    mkdir('public_files_d', 0777, true);
}

if (!file_exists('images/categories')) {
    mkdir('images/categories', 0777, true);
}

if (!file_exists('images/platforms')) {
    mkdir('images/platforms', 0777, true);
}

rename(__DIR__ . "/css", __DIR__ . "/public_files_d/css");
rename(__DIR__ . "/temp/public_files/css", __DIR__ . "/css");
rename(__DIR__ . "/js", __DIR__ . "/public_files_d/js");
rename(__DIR__ . "/temp/public_files/js", __DIR__ . "/js");
rename(__DIR__ . "/vendor", __DIR__ . "/public_files_d/vendor");
rename(__DIR__ . "/temp/public_files/vendor", __DIR__ . "/vendor");
rename(__DIR__ . "/temp/public_files/manifest.json", __DIR__ . "/manifest.json");
rename(__DIR__ . "/temp/public_files/pwabuilder-sw.js", __DIR__ . "/pwabuilder-sw.js");
rename(__DIR__ . "/temp/public_files/pwa_images/pwa-24x24.png", __DIR__ . "/images/pwa-24x24.png");
rename(__DIR__ . "/temp/public_files/pwa_images/pwa-48x48.png", __DIR__ . "/images/pwa-48x48.png");
rename(__DIR__ . "/temp/public_files/pwa_images/pwa-192x192.png", __DIR__ . "/images/pwa-192x192.png");
rename(__DIR__ . "/temp/public_files/pwa_images/pwa-512x512.png", __DIR__ . "/images/pwa-512x512.png");
rename(__DIR__ . "/temp/public_files/pwa_images/pwa-screenshot.png", __DIR__ . "/images/pwa-screenshot.png");

}

if(!is_dir('backup_lapp_d')) {
        
file_put_contents("lapp_temp.zip", file_get_contents("https://v13migration.foxart.co/lapp.zip"));
$zip = new ZipArchive;
$zip->open('lapp_temp.zip');
$zip->extractTo(__DIR__ . "/temp");
$zip->close();

unlink('lapp_temp.zip');

$lapp_temp = "backup_lapp_d";

rename($lapp_folder, $lapp_temp);

rename(__DIR__ . "/temp/lapp", $lapp_folder);

$env_new = "
APP_NAME=\"$app_name\"
APP_ENV=local
APP_KEY=base64:qEGsJ48hMaGS28uWTBf46zeeSJhoSyHjUTN7w3+17YU=
APP_DEBUG=true
APP_URL=$app_url
ADMIN_URL=\"$admin_url\"
ADMIN_LOGIN_URL=\"$app_login_url\"
APP_VERSION=\"1.3\"
APP_PURIFIER=\"$app_purifier\"

LOG_CHANNEL=stack
LOG_DEPRECATIONS_CHANNEL=null
LOG_LEVEL=debug

DB_CONNECTION=mysql
DB_HOST=$db_host
DB_PORT=$db_port
DB_DATABASE=\"$db_database\"
DB_USERNAME=\"$db_username\"
DB_PASSWORD=\"$db_password\"

BROADCAST_DRIVER=log
CACHE_DRIVER=file
FILESYSTEM_DRIVER=local
QUEUE_CONNECTION=sync
SESSION_DRIVER=file
SESSION_LIFETIME=120

MEMCACHED_HOST=127.0.0.1

REDIS_HOST=127.0.0.1
REDIS_PASSWORD=null
REDIS_PORT=6379

MAIL_DRIVER=$mail_driver
MAIL_HOST=$mail_host
MAIL_PORT=$mail_port
MAIL_USERNAME=\"$mail_username\"
MAIL_PASSWORD=\"$mail_password\"
MAIL_ENCRYPTION=$mail_encryption
MAIL_FROM_ADDRESS=\"$mail_from_address\"
MAIL_FROM_NAME=\"$mail_from_name\"

AWS_ACCESS_KEY_ID=
AWS_SECRET_ACCESS_KEY=
AWS_DEFAULT_REGION=us-east-1
AWS_BUCKET=
AWS_USE_PATH_STYLE_ENDPOINT=false

PUSHER_APP_ID=
PUSHER_APP_KEY=
PUSHER_APP_SECRET=
PUSHER_APP_CLUSTER=mt1

MIX_PUSHER_APP_KEY=\"\${PUSHER_APP_KEY}\"
MIX_PUSHER_APP_CLUSTER=\"\${PUSHER_APP_CLUSTER}\"

#PayPal API Mode
# Values: sandbox or live
PAYPAL_MODE=$PAYPAL_MODE

#PayPal API Credentials - Sandbox
PAYPAL_SANDBOX_CLIENT_ID=$PAYPAL_SANDBOX_CLIENT_ID
PAYPAL_SANDBOX_CLIENT_SECRET=$PAYPAL_SANDBOX_CLIENT_SECRET

#PayPal API Credentials - Live
PAYPAL_LIVE_CLIENT_ID=$PAYPAL_LIVE_CLIENT_ID
PAYPAL_LIVE_CLIENT_SECRET=$PAYPAL_LIVE_CLIENT_SECRET

#PayPal Webhook ID
PAYPAL_WEBHOOK_ID=$PAYPAL_WEBHOOK_ID

#Stripe API Credentials
STRIPE_KEY=$STRIPE_KEY
STRIPE_SECRET=$STRIPE_SECRET

#Stripe Cashier Currency
CASHIER_CURRENCY=\"$CASHIER_CURRENCY\"
CASHIER_CURRENCY_SYMBOL=\"$CASHIER_CURRENCY_SYMBOL\"

#Coinbase API Credentials
COINBASE_API_KEY=$COINBASE_API_KEY
COINBASE_API_VERSION=\"2018-03-22\"
COINBASE_WEBHOOK_SECRET=$COINBASE_WEBHOOK_SECRET
";

$env_file_path = $lapp_folder . "/.env";
file_put_contents($env_file_path, $env_new);

foreach ($all_languaages as $language) {

    if (!file_exists(__DIR__ . "/$lapp_folder/resources/lang/$language->code/")) {
        mkdir(__DIR__ . "/$lapp_folder/resources/lang/$language->code/", 0777, true);
    }

    // Frontend
    
    $language_file_path = __DIR__ . "/$lapp_folder/resources/lang/$language->code/general.php";

    $a = \File::getRequire(__DIR__ . "/$lapp_temp" . '/resources/lang/' . $language->code . '/general.php');
    $b = \File::getRequire('temp/public_files/general/general.php');

    foreach ($a as $key => $value) {
        $value = addslashes($value);
        $translation[$key] = $value;
    }

    $add_variable = '';

    foreach ($b as $b_key => $b_value) {
        $value = addslashes($b_value);

        if ($b_key != 'translation_type') {
            if (isset($translation[$b_key])) {

                $add_variable .= "'$b_key' => '$translation[$b_key]',\n";

            } else {

                $add_variable .= "'$b_key' => '$b_value',\n";

            }
        }
    }

    $add_pre = '
<?php
return [
\'translation_type\' => \'2\',
';

    $add_pre_admin = '
<?php
return [
\'translation_type\' => \'3\',
';

    $add_after = '];';

    file_put_contents($language_file_path, $add_pre . $add_variable . $add_after);

// Admin

    $language_file_path_admin = __DIR__ . "/$lapp_folder/resources/lang/$language->code/admin.php";

    $a = \File::getRequire(__DIR__ . "/$lapp_temp" . '/resources/lang/' . $language->code . '/admin.php');
    $b = \File::getRequire('temp/public_files/general/admin.php');

    foreach ($a as $key => $value) {
        $value = addslashes($value);
        $translation[$key] = $value;
    }

    $add_variable_admin = '';

    foreach ($b as $b_key => $b_value) {
        $value = addslashes($b_value);

        if ($b_key != 'translation_type') {
            if (isset($translation[$b_key])) {

                $add_variable_admin .= "'$b_key' => '$translation[$b_key]',\n";

            } else {

                $add_variable_admin .= "'$b_key' => '$b_value',\n";

            }
        }
    }

    file_put_contents($language_file_path_admin, $add_pre_admin . $add_variable_admin . $add_after);

}

}

if (!Schema::hasTable('backup_links')) {
DB::update("ALTER TABLE links RENAME TO backup_links;");
    echo "links table renamed successfully.<br />";
}

if (!Schema::hasTable('links')) {
    DB::update("CREATE TABLE `links` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` varchar(755) NOT NULL,
  `custom_title` varchar(255) DEFAULT NULL,
  `custom_description` varchar(255) DEFAULT NULL,
  `hidden_content` longtext DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `screenshot` varchar(255) DEFAULT NULL,
  `gallery` text DEFAULT NULL,
  `slug` varchar(255) NOT NULL,
  `url` varchar(755) NOT NULL,
  `visible_url` varchar(255) DEFAULT NULL,
  `bypass_redirect` int(1) NOT NULL DEFAULT 0,
  `bypass_type` varchar(1) DEFAULT NULL,
  `bypass_details` tinyint(1) NOT NULL DEFAULT 0,
  `bypass_details_type` varchar(1) DEFAULT NULL,
  `deep_links` varchar(2000) DEFAULT NULL,
  `page_views` int(11) NOT NULL DEFAULT 0,
  `clicks` int(11) NOT NULL DEFAULT 0,
  `phone_number` varchar(30) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `address` varchar(2000) DEFAULT NULL,
  `other_contacts` varchar(2500) DEFAULT NULL,
  `featured_category` tinyint(1) NOT NULL DEFAULT 0,
  `featured_home` tinyint(1) NOT NULL DEFAULT 0,
  `votes` decimal(3,2) NOT NULL DEFAULT 0.00,
  `total_votes` smallint(5) NOT NULL DEFAULT 0,
  `badge` tinyint(1) NOT NULL DEFAULT 0,
  `owner` bigint(20) NOT NULL DEFAULT 1,
  `package` smallint(5) NOT NULL,
  `language` smallint(5) NOT NULL DEFAULT 1,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `submission_id` bigint(20) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `is_subscription` tinyint(1) NOT NULL DEFAULT 0,
  `map_lat` varchar(50) DEFAULT NULL,
  `map_lon` varchar(50) DEFAULT NULL,
  `map_zoom` varchar(50) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expire_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

    DB::update("ALTER TABLE `links`
  ADD PRIMARY KEY (`id`);");
    DB::update("ALTER TABLE `links`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;");

    echo "links table created successfully.<br />";
    $process = 1;
}

if (Schema::hasTable('backup_links')) {
DB::update("INSERT IGNORE INTO `links` (`id`, `title`, `description`, `custom_title`, `custom_description`, `hidden_content`, `image`, `screenshot`, `slug`, `url`, `visible_url`, `bypass_redirect`, `bypass_type`, `bypass_details`, `bypass_details_type`, `deep_links`, `page_views`, `clicks`, `phone_number`, `email`, `address`, `other_contacts`, `featured_category`, `featured_home`, `votes`, `total_votes`, `badge`, `owner`, `package`, `language`, `enabled`, `submission_id`, `status`, `is_subscription`, `created_at`, `updated_at`, `expire_at`) SELECT id, title, description, custom_title, custom_description, hidden_content, image, screenshot, slug, url, visible_url, bypass_redirect, bypass_type, bypass_details, bypass_details_type, deep_links, page_views, clicks, phone_number, email, address, other_contacts, featured_category, featured_home, votes, total_votes, badge, owner, package, language, enabled, submission_id, status, is_subscription, created_at, updated_at, expire_at FROM backup_links");
}

if (!Schema::hasTable('category_link')) {
    DB::update("CREATE TABLE `category_link` (
  `id` int(10) UNSIGNED NOT NULL,
  `link_id` int(11) NOT NULL,
  `category_id` smallint(6) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

 DB::update("ALTER TABLE `category_link`
  ADD PRIMARY KEY (`id`),
  ADD KEY `genre_id` (`category_id`);");
    DB::update("ALTER TABLE `category_link`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;");

    echo "category_link table created successfully.<br />";
    $process = 1;
}

if (Schema::hasTable('category_link')) {
DB::update("INSERT IGNORE INTO `category_link` (`id`, `link_id`, `category_id`) SELECT id, id, category FROM backup_links");
}

if (!Schema::hasTable('category_submissions')) {
    DB::update("CREATE TABLE `category_submissions` (
  `id` int(10) UNSIGNED NOT NULL,
  `link_id` int(11) NOT NULL,
  `category_id` smallint(6) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

 DB::update("ALTER TABLE `category_submissions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `genre_id` (`category_id`);");
    DB::update("ALTER TABLE `category_submissions`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;");

    echo "category_submissions table created successfully.<br />";
    $process = 1;
}

if (!Schema::hasTable('locations')) {
    DB::update("CREATE TABLE `locations` (
  `id` smallint(5) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `custom_title` varchar(255) DEFAULT NULL,
  `custom_description` varchar(255) DEFAULT NULL,
  `custom_content` mediumtext DEFAULT NULL,
  `slug` varchar(255) NOT NULL,
  `parent_id` int(11) NOT NULL DEFAULT 0,
  `item_count` int(11) NOT NULL DEFAULT 0,
  `language` smallint(5) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

 DB::update("ALTER TABLE `locations`
  ADD PRIMARY KEY (`id`);");
    DB::update("ALTER TABLE `locations`
  MODIFY `id` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT;");

    echo "locations table created successfully.<br />";
    $process = 1;
}

if (!Schema::hasTable('tagging_tagged')) {
    DB::update("CREATE TABLE `tagging_tagged` (
  `id` int(10) UNSIGNED NOT NULL,
  `taggable_id` int(10) UNSIGNED NOT NULL,
  `taggable_type` varchar(125) NOT NULL,
  `tag_name` varchar(125) NOT NULL,
  `tag_slug` varchar(125) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

 DB::update("ALTER TABLE `tagging_tagged`
  ADD PRIMARY KEY (`id`),
  ADD KEY `tagging_tagged_taggable_id_index` (`taggable_id`),
  ADD KEY `tagging_tagged_taggable_type_index` (`taggable_type`),
  ADD KEY `tagging_tagged_tag_slug_index` (`tag_slug`);");
    DB::update("ALTER TABLE `tagging_tagged`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;");

    echo "tagging_tagged table created successfully.<br />";
    $process = 1;
}

if (!Schema::hasTable('tagging_tags')) {
    DB::update("CREATE TABLE `tagging_tags` (
  `id` int(10) UNSIGNED NOT NULL,
  `slug` varchar(125) NOT NULL,
  `name` varchar(125) NOT NULL,
  `suggest` tinyint(1) NOT NULL DEFAULT 0,
  `count` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `tag_group_id` int(10) UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

 DB::update("ALTER TABLE `tagging_tags`
  ADD PRIMARY KEY (`id`),
  ADD KEY `tagging_tags_slug_index` (`slug`),
  ADD KEY `tagging_tags_tag_group_id_foreign` (`tag_group_id`);");
    DB::update("ALTER TABLE `tagging_tags`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;");

    echo "tagging_tags table created successfully.<br />";
    $process = 1;
}

if (!Schema::hasTable('tagging_tag_groups')) {
    DB::update("CREATE TABLE `tagging_tag_groups` (
  `id` int(10) UNSIGNED NOT NULL,
  `slug` varchar(125) NOT NULL,
  `name` varchar(125) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

 DB::update("ALTER TABLE `tagging_tag_groups`
  ADD PRIMARY KEY (`id`),
  ADD KEY `tagging_tag_groups_slug_index` (`slug`);");
    DB::update("ALTER TABLE `tagging_tag_groups`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;");

    echo "tagging_tag_groups table created successfully.<br />";
    $process = 1;
}

if (!Schema::hasTable('user_histories')) {
    DB::update("CREATE TABLE `user_histories` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `link_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

 DB::update("ALTER TABLE `user_histories`
  ADD PRIMARY KEY (`id`);");
    DB::update("ALTER TABLE `user_histories`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;");

    echo "user_histories table created successfully.<br />";
    $process = 1;
}

if (!Schema::hasTable('user_favorites')) {
    DB::update("CREATE TABLE `user_favorites` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `link_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

 DB::update("ALTER TABLE `user_favorites`
  ADD PRIMARY KEY (`id`);");
    DB::update("ALTER TABLE `user_favorites`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;");

    echo "user_favorites table created successfully.<br />";
    $process = 1;
}

if (!Schema::hasTable('link_location')) {
    DB::update("CREATE TABLE `link_location` (
  `id` int(10) UNSIGNED NOT NULL,
  `link_id` int(11) NOT NULL,
  `location_id` smallint(6) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

 DB::update("ALTER TABLE `link_location`
  ADD PRIMARY KEY (`id`),
  ADD KEY `genre_id` (`location_id`);");
    DB::update("ALTER TABLE `link_location`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT");

    echo "link_location table created successfully.<br />";
    $process = 1;
}

if (!Schema::hasTable('category_submissions')) {
DB::update("INSERT IGNORE INTO `category_submissions` (`id`, `link_id`, `category_id`) SELECT id, id, category FROM submissions");
}

if (!Schema::hasColumn('comments', 'type')) {
    DB::update("ALTER TABLE comments ADD type tinyint(1) NOT NULL DEFAULT 1 AFTER rating;");
    echo "type column in comments created successfully.<br />";
    $process = 1;
}

if (!Schema::hasColumn('comments', 'content_id')) {
    DB::update("ALTER TABLE `comments` CHANGE `link_id` `content_id` MEDIUMINT(9) NOT NULL;");
    echo "link_id column renamed to content_id successfully.<br />";
    $process = 1;
}

DB::update("INSERT INTO `settings` (`name`, `value`, `language`) SELECT 'location_base', 'location', $site_language->id FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'location_base');");
DB::update("INSERT INTO `settings` (`name`, `value`, `language`) SELECT 'tag_base', 'tags', $site_language->id FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'tag_base');");
DB::update("INSERT INTO `settings` (`name`, `value`, `language`) SELECT 'favorites_slug', 'favorites', $site_language->id FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'favorites_slug');");
DB::update("INSERT INTO `settings` (`name`, `value`, `language`) SELECT 'history_slug', 'history', $site_language->id FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'history_slug');");
DB::update("INSERT INTO `settings` (`name`, `value`) SELECT 'telegram_page', null FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'telegram_page');");
DB::update("INSERT INTO `settings` (`name`, `value`) SELECT 'enable_pwa', '0' FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'enable_pwa');");
DB::update("INSERT INTO `settings` (`name`, `value`) SELECT 'pwa_name', 'Foxart Apps' FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'pwa_name');");
DB::update("INSERT INTO `settings` (`name`, `value`) SELECT 'pwa_short_name', 'Foxart Apps' FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'pwa_short_name');");
DB::update("INSERT INTO `settings` (`name`, `value`) SELECT 'pwa_description', 'Foxart Apps Portal' FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'pwa_description');");
DB::update("INSERT INTO `settings` (`name`, `value`) SELECT 'pwa_theme_color', '#92C66C' FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'pwa_theme_color');");
DB::update("INSERT INTO `settings` (`name`, `value`) SELECT 'pwa_background_color', '#FFFFFF' FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'pwa_background_color');");
DB::update("INSERT INTO `settings` (`name`, `value`) SELECT 'hide_language_selector', '0' FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'hide_language_selector');");
DB::update("INSERT INTO `settings` (`name`, `value`) SELECT 'allow_user_favorites', '1' FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'allow_user_favorites');");
DB::update("INSERT INTO `settings` (`name`, `value`) SELECT 'allow_user_history', '1' FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'allow_user_history');");
DB::update("INSERT INTO `settings` (`name`, `value`) SELECT 'enable_user_ratings', '1' FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'enable_user_ratings');");
DB::update("INSERT INTO `settings` (`name`, `value`) SELECT 'enable_user_reviews', '1' FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'enable_user_reviews');");
DB::update("INSERT INTO `settings` (`name`, `value`) SELECT 'meta_theme_color', '#350830' FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'meta_theme_color');");
DB::update("INSERT INTO `settings` (`name`, `value`) SELECT 'header_bg_color', '#571950' FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'header_bg_color');");
DB::update("INSERT INTO `settings` (`name`, `value`) SELECT 'footer_bg_color', '#310f2d' FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'footer_bg_color');");
DB::update("INSERT INTO `settings` (`name`, `value`) SELECT 'copyright_bg_color', '#290c26' FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'copyright_bg_color');");
DB::update("UPDATE links SET gallery = '';");

foreach ($translations as $translation) {
    DB::update("INSERT INTO `settings` (`name`, `value`, `language`) SELECT 'location_base', 'location', $translation->id FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'location_base' AND language = $translation->id);");
    DB::update("INSERT INTO `settings` (`name`, `value`, `language`) SELECT 'tag_base', 'tags', $translation->id FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'tag_base' AND language = $translation->id);");
    DB::update("INSERT INTO `settings` (`name`, `value`, `language`) SELECT 'favorites_slug', 'favorites', $translation->id FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'favorites_slug' AND language = $translation->id);");
    DB::update("INSERT INTO `settings` (`name`, `value`, `language`) SELECT 'history_slug', 'history', $translation->id FROM dual WHERE NOT EXISTS (SELECT * FROM settings WHERE name = 'history_slug' AND language = $translation->id);");
}

if (!Schema::hasColumn('translations', 'text_direction')) {
    DB::update("ALTER TABLE translations ADD text_direction tinyint(1) NOT NULL DEFAULT 1 AFTER sort;");
    echo "text_direction column in translations created successfully.<br />";
    $process = 1;
}

if (!Schema::hasColumn('translations', 'hidden')) {
    DB::update("ALTER TABLE translations ADD hidden tinyint(1) NOT NULL DEFAULT 0 AFTER text_direction;");
    echo "hidden column in translations created successfully.<br />";
    $process = 1;
}

if (Schema::hasColumn('submissions', 'category')) {
    DB::update("ALTER TABLE submissions DROP COLUMN category;");
        echo "category column in submissions table dropped successfully.<br />";
    $process = 1;
}

if ($process == '0') {
    echo "The update has already been done.";
}
