<?php
namespace App\Http\Controllers;

use App;
use App\Models\Category;
use App\Models\Package;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\View;

class OrderController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');

        // Site Settings
        $site_settings = DB::table('settings')->get();

        foreach ($site_settings as $setting) {
            $settings[$setting->name] = $setting->value;
        }

        // List of packages
        $packages = Package::get();
        
        foreach ($packages as $package) {
        $package_name[$package->id]=$package->title;
        }

        // List of payment methods
        $payment_methods = DB::table('payment_methods')->get();

        foreach ($payment_methods as $method) { 
        $payment_method_name[$method->id]=__('general.'.$method->title.'');
        }

        // List of categories
        $categories = Category::get();
        
        foreach ($categories as $category) {
        $category_name[$category->id]=$category->title;
        }
        
        // Array Data
        $array_data = array(
            'package_name' => $package_name,
            'payment_method_name' => $payment_method_name,
            'category_name' => $category_name ?? '',
        );

        // Pass data to views
        View::share(['settings' => $settings, 'packages' => $packages, 'payment_methods' => $payment_methods, 'categories' => $categories, 'array_data' => $array_data]);
    }

    /** Index */
    public function index()
    {
        // List of orders
        $orders = DB::table('orders')
            ->orderBy('id', 'desc')
            ->paginate(15);

        // Return view
        return view('adminlte::orders.index', compact('orders'));
    }

    /** Edit */
    public function edit($id)
    {
        // Retrieve order details
        $order = DB::table('orders')
            ->leftJoin('submissions', 'orders.submission_id', '=', 'submissions.id')
            ->select('orders.id AS order_id', 'orders.*', 'submissions.*')
            ->where('orders.id', $id)
            ->orderBy('submissions.id', 'ASC')
            ->first();

        // Return 404 page if order not found
        if ($order == null) {
            abort(404);
        }

        $deep_link_data = unserialize($order->deep_links);

        if (!$deep_link_data) {
            $deep_link_data = array(
                "link_1" => array("title" => null, "url" => null, "type" => null),
                "link_2" => array("title" => null, "url" => null, "type" => null),
                "link_3" => array("title" => null, "url" => null, "type" => null),
            );
        }
        
        $order_categories = DB::table('category_submissions')->orderBy('id', 'desc')->where('link_id', $id)->get()->pluck('category_id')->toArray();
        
        $other_contacts = unserialize($order->other_contacts);

        if (!$other_contacts) {
            $other_contacts = array(
                "facebook_url" => array("url" => null),
                "twitter_url" => array("url" => null),
                "instagram_url" => array("url" => null),
                "linkedin_url" => array("url" => null),
                "whatsapp_number" => array("number" => null),
                "telegram_url" => array("url" => null),
            );
        }

        // Return view
        return view('adminlte::orders.view')->with('order', $order)->with('deep_link_data', $deep_link_data)->with('other_contacts', $other_contacts)->with('order_categories', $order_categories);

    }

}
