<?php
namespace App\Http\Controllers;

use App;
use App\Models\Setting;
use App\Models\Translation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\View;
use Intervention\Image\ImageManagerStatic as Image;
use Purifier;
use File;

class SettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');

        // Site Settings
        $site_settings = DB::table('settings')->get();

        foreach ($site_settings as $setting) {
            $this->settings[$setting->name] = $setting->value;
        }

        // Language names in their own language
        $language_translation = DB::table('translations')->get()->pluck('language', 'code');
        $language_translation = $language_translation->toArray();

        // Pass data to views
        View::share(['settings' => $this->settings, 'language_translation' => $language_translation]);
    }

    /** Index */
    public function index(Request $request)
    {
        // Generate Cronjob Code
        if ($request->has('cronjob_code')) {
            $rand = substr(str_shuffle(str_repeat("0123456789abcdefghijklmnopqrstuvwxyz", 25)), 0, 25);

            // Update cronjob link
            DB::table('settings')->where('name', 'cronjob_code')->update(['value' => $rand]);

            // New Cronjob Link
            $new_link = asset('cronjob/' . $rand);

            // Redirect to settings page
            return redirect(env('ADMIN_URL') . '/payment_listing_settings')->with('success', __('admin.new_link_generated') . ": $new_link");
        }

        // Generate Paypal Webhook Code
        if ($request->has('paypal_webhook_code')) {
            $rand = substr(str_shuffle(str_repeat("0123456789abcdefghijklmnopqrstuvwxyz", 25)), 0, 25);

            // Update cronjob link
            DB::table('settings')->where('name', 'paypal_webhook_code')->update(['value' => $rand]);

            // New Cronjob Link
            $new_link = asset('api/paypal-webhook/' . $rand);

            // Redirect to settings page
            return redirect(env('ADMIN_URL') . '/payment_listing_settings')->with('success', __('admin.new_link_generated') . ": $new_link");
        }

        // Return view
        return view('adminlte::settings.site');
    }

    // Checkbox Update Function
    public function checkbox_update($box, $box_data)
    {
        if ($box_data == 'on') {
            DB::update("update settings set value = '1' WHERE name = '$box'");
        } else {
            DB::update("update settings set value = '0' WHERE name = '$box'");
        }
    }

    // Payment Methods Checkbox Update Function
    public function payment_methods_update($id, $box_data)
    {
        if ($box_data == 'on') {
            DB::update("update payment_methods set enabled = '1' WHERE id = '$id'");
        } else {
            DB::update("update payment_methods set enabled = '0' WHERE id = '$id'");
        }
    }

    /** Store */
    public function store(Request $request)
    {
        $this->validate($request, [
            'links_per_page' => 'required|numeric',
            'time_before_redirect' => 'required|numeric',
            'search_page_links_per_page' => 'required|numeric',
            'ga_tracking_id' => ['regex:/^[A-Z0-9_\-]*$/', 'nullable'],
            'ga_publisher_id' => 'nullable|numeric',
            'admin_email' => 'required|email',
            'image_quality' => 'required|integer|between:0,100',
        ]);

        foreach ($request->except(array(
            '_token',
            '_method',
        )) as $key => $value) {

            $value = addslashes($value);
            if ($_ENV['APP_PURIFIER'] == '1') {
                $value = Purifier::clean($value, 'titles');
            }

            // Update settings
            DB::update("update settings set value = '$value' WHERE name = '$key'");

            $this->checkbox_update('show_random_link', $request->get('show_random_link'));
            $this->checkbox_update('show_cookie_bar', $request->get('show_cookie_bar'));
            $this->checkbox_update('enable_submission_form', $request->get('enable_submission_form'));
            $this->checkbox_update('auto_submission', $request->get('auto_submission'));
            $this->checkbox_update('show_rss_feed', $request->get('show_rss_feed'));
            $this->checkbox_update('use_text_logo', $request->get('use_text_logo'));
            $this->checkbox_update('breadcrumbs', $request->get('breadcrumbs'));
            $this->checkbox_update('ping_google', $request->get('ping_google'));
            $this->checkbox_update('show_qr_code', $request->get('show_qr_code'));
            $this->checkbox_update('enable_report_form', $request->get('enable_report_form'));
            $this->checkbox_update('enable_google_recaptcha', $request->get('enable_google_recaptcha'));
            $this->checkbox_update('show_page_views', $request->get('show_page_views'));
            $this->checkbox_update('show_clicks', $request->get('show_clicks'));
            $this->checkbox_update('count_home', $request->get('count_home'));
            $this->checkbox_update('sub_count_home', $request->get('sub_count_home'));
            $this->checkbox_update('sub_count_category', $request->get('sub_count_category'));
            $this->checkbox_update('sticky_ads_right_column', $request->get('sticky_ads_right_column'));
            $this->checkbox_update('page_view_once', $request->get('page_view_once'));
            $this->checkbox_update('show_phone_number_country_code', $request->get('show_phone_number_country_code'));
            $this->checkbox_update('show_featured_text', $request->get('show_featured_text'));
            $this->checkbox_update('show_featured_links_randomly', $request->get('show_featured_links_randomly'));
            $this->checkbox_update('show_articles_in_header', $request->get('show_articles_in_header'));
            $this->checkbox_update('search_categories', $request->get('search_categories'));
            $this->checkbox_update('show_links_under_subcategories', $request->get('show_links_under_subcategories'));
            $this->checkbox_update('save_as_webp', $request->get('save_as_webp'));
            $this->checkbox_update('infinite_scroll', $request->get('infinite_scroll'));
            $this->checkbox_update('enable_registration', $request->get('enable_registration'));
            $this->checkbox_update('save_screenshot_as_icon', $request->get('save_screenshot_as_icon'));
            $this->checkbox_update('scrollable_articles_home_page', $request->get('scrollable_articles_home_page'));
            $this->checkbox_update('optional_submission_icon', $request->get('optional_submission_icon'));
            $this->checkbox_update('allow_widget_embed', $request->get('allow_widget_embed'));
            $this->checkbox_update('root_language', $request->get('root_language'));
            $this->checkbox_update('redirection_page_noindex', $request->get('redirection_page_noindex'));
            $this->checkbox_update('enable_live_ajax_search', $request->get('enable_live_ajax_search'));
            $this->checkbox_update('enable_user_ratings', $request->get('enable_user_ratings'));
            $this->checkbox_update('enable_user_reviews', $request->get('enable_user_reviews'));
            $this->checkbox_update('hide_language_selector', $request->get('hide_language_selector'));
            $this->checkbox_update('allow_user_history', $request->get('allow_user_history'));
            $this->checkbox_update('allow_user_favorites', $request->get('allow_user_favorites'));

            // Check if the default share image is uploaded
            if ($request->hasFile('default_share_image')) {
                $image = $request->file('default_share_image');
                $filename = 'default_share_image.png';
                $location = public_path('images/' . $filename);
                Image::make($image)->resize(600, 315)
                    ->save($location);
            }

            // Check if the default link image is uploaded
            if ($request->hasFile('default_link_image')) {
                $image = $request->file('default_link_image');
                $filename = 'no_image.png';
                $location = public_path('images/links/' . $filename);
                Image::make($image)->resize(200, 200)
                    ->save($location);
            }

            // Check if the default category image is uploaded
            if ($request->hasFile('default_category_image')) {
                $image = $request->file('default_category_image');
                $filename = 'no_image.png';
                $location = public_path('images/categories/' . $filename);
                Image::make($image)->resize(200, 200)
                    ->save($location);
            }

            // Check if the site logo is uploaded
            if ($request->hasFile('site_logo')) {
                $image = $request->file('site_logo');
                $filename = 'logo.png';
                $location = public_path('images/' . $filename);
                Image::make($image)->save($location);
            }

            // Check if the favicon is uploaded
            if ($request->hasFile('favicon')) {
                $image = $request->file('favicon');
                $filename = 'favicon.png';
                $location = public_path('images/' . $filename);
                Image::make($image)->resize(192, 192)
                    ->save($location);
            }

            $custom_css = '.header-container {
    background-color: ' . $request->get('header_bg_color') . ';
}

.footer-container {
    background-color: ' . $request->get('footer_bg_color') . ';
}

.footer-copyright {
    background-color: ' . $request->get('copyright_bg_color') . ';
}';

                File::put('css/custom.css', $custom_css);

        }

        // Redirect to settings page
        return redirect(env('ADMIN_URL') . '/settings')->with('success', __('admin.data_updated'));
    }

    /** SEO Settings */
    public function seo_settings()
    {
        // List of languages
        $translations = Translation::orderBy('id', 'ASC')->get();

        foreach ($translations as $language) {
            $language_code[$language->id] = $language->icon;
        }

        // Return view
        return view('adminlte::settings.seo_settings')->with('translations', $translations)->with('language_menu', '1')->with('language_code', $language_code);
    }

    /** Language SEO Settings */
    public function seo_settings_language(Request $request)
    {
        $id = request()->id;

        // Language details
        $translation = Translation::where('id', $id)->first();

        // Return 404 page if language not found
        if ($translation == null) {
            abort(404);
        }

        // Site Settings
        $site_settings_seo = DB::table('settings')->where('language', $id)->get();

        foreach ($site_settings_seo as $seo_setting) {
            $seo_settings[$seo_setting->name] = $seo_setting->value;
        }

        // Return view
        return view('adminlte::settings.seo_settings')->with('seo_settings', $seo_settings)->with('language_menu', '0');
    }

    /** SEO Settings Update */
    public function seo_settings_update(Request $request)
    {
        $id = request()->id;

        $this->validate($request, [
            'site_title' => 'required',
            'site_description' => 'required',
            'detail_base' => 'required',
            'category_base' => 'required',
            'redirect_base' => 'required',
            'page_base' => 'required',
            'article_base' => 'required',
            'latest_links_slug' => 'required',
            'popular_links_slug' => 'required',
            'all_articles_slug' => 'required',
            'contact_slug' => 'required',
            'favorites_slug' => 'required',
            'history_slug' => 'required',
            'location_base' => 'required',
            'tag_base' => 'required',
        ]);

        foreach ($request->except(array(
            '_token',
            '_method',
        )) as $key => $value) {

            $value = addslashes($value);

            // Update settings
            DB::update("update settings set value = '$value' WHERE name = '$key' AND language = '$id'");
        }

        // Redirect to SEO settings page
        return back()->with('success', __('admin.data_updated'));

    }

    /** Payment Settings */
    public function payment_listing_settings()
    {
        // List of payment methods
        $payment_methods = DB::table('payment_methods')->get(['id', 'enabled'])->keyBy('id')->toArray();

        // Return view
        return view('adminlte::settings.payment_listing_settings')->with('payment_methods', $payment_methods);
    }

    /** Payment & Listing Settings Update */
    public function payment_listing_settings_update(Request $request)
    {
        $this->validate($request, [
            'payment_currency' => 'required',
            'payment_currency_symbol' => 'required',
            'grace_period' => 'required|numeric|min:0',
        ]);

        foreach ($request->except(array(
            '_token',
            '_method',
        )) as $key => $value) {

            $value = addslashes($value);

            // Update settings
            DB::update("update settings set value = '$value' WHERE name = '$key'");

            $this->checkbox_update('allow_user_updates', $request->get('allow_user_updates'));
            $this->payment_methods_update('1', $request->get('1'));
            $this->payment_methods_update('2', $request->get('2'));
            $this->payment_methods_update('3', $request->get('3'));
            $this->payment_methods_update('4', $request->get('4'));
            $this->payment_methods_update('5', $request->get('5'));
        }

        // Redirect to payment settings page
        return redirect(env('ADMIN_URL') . '/payment_listing_settings')->with('success', __('admin.data_updated'));
    }

       /** PWA Settings */
       public function pwa_settings()
       {
           // Return view
           return view('adminlte::settings.pwa_settings');
       }
   
       /** PWA Settings Update */
       public function pwa_settings_update(Request $request)
       {
   
           $this->validate($request, [
               'pwa_name' => 'required|max:255',
               'pwa_short_name' => 'required|max:255',
               'pwa_description' => 'required|max:255',
               'pwa_theme_color' => 'required|max:7',
               'pwa_background_color' => 'required|max:7',
           ]);
   
           foreach ($request->except(array(
               '_token',
               '_method',
           )) as $key => $value) {
   
               $value = addslashes($value);
   
               // Update settings
               DB::update("update settings set value = '$value' WHERE name = '$key'");
   
               $manifest_json = '{
     "id": "/",
     "scope": "/",
     "name": "' . $request->get('pwa_name') . '",
     "display": "standalone",
     "start_url": "/",
     "short_name": "' . $request->get('pwa_short_name') . '",
     "theme_color": "' . $request->get('pwa_theme_color') . '",
     "description": "' . $request->get('pwa_description') . '",
     "orientation": "portrait",
     "background_color": "' . $request->get('pwa_background_color') . '",
     "related_applications": [],
     "prefer_related_applications": false,
     "display_override": [],
     "icons": [
       {
         "src": "/images/pwa-512x512.png",
         "sizes": "512x512",
         "type": "image/png"
       },
       {
         "src": "/images/pwa-192x192.png",
         "sizes": "192x192",
         "type": "image/png"
       },
       {
         "src": "/images/pwa-48-48.png",
         "sizes": "48x48",
         "type": "image/png"
       },
       {
         "src": "/images/pwa-24-24.png",
         "sizes": "24x24",
         "type": "image/png"
       }
     ],
     "screenshots": [
       {
         "src": "/images/pwa-screenshot.png",
         "sizes": "1080x1910",
         "type": "image/png"
       }
     ],
    "features": [
       "Cross Platform",
       "fast",
       "simple"
     ],
     "categories": [
       "utilities"
     ],
     "shortcuts": []
   }';
   
               File::put('manifest.json', $manifest_json);
   
               // Upload PWA Screenshot
               if ($request->hasFile('pwa_screenshot')) {
                   $image = $request->file('pwa_screenshot');
                   $location = public_path('images/pwa-screenshot.png');
                   Image::make($image)->resize(1080, 1920)->save($location);
               }
   
               // Upload PWA Icon (512x512)
               if ($request->hasFile('pwa_512')) {
                   $image = $request->file('pwa_512');
                   $location = public_path('images/pwa-512x512.png');
                   Image::make($image)->resize(512, 512)->save($location);
               }
   
               // Upload PWA Icon (192x192)
               if ($request->hasFile('pwa_192')) {
                   $image = $request->file('pwa_192');
                   $location = public_path('images/pwa-192x192.png');
                   Image::make($image)->resize(192, 192)->save($location);
               }
   
               // Upload PWA Icon (48x48)
               if ($request->hasFile('pwa_48')) {
                   $image = $request->file('pwa_48');
                   $location = public_path('images/pwa-48x48.png');
                   Image::make($image)->resize(48, 48)->save($location);
               }
   
               // Upload PWA Icon (24x24)
               if ($request->hasFile('pwa_24')) {
                   $image = $request->file('pwa_24');
                   $location = public_path('images/pwa-24x24.png');
                   Image::make($image)->resize(24, 24)->save($location);
               }
   
               $this->checkbox_update('enable_pwa', $request->get('enable_pwa'));
           }
   
           // Redirect to PWA settings page
           return back()->with('success', __('admin.data_updated'));
       }

    /** Mail Settings */
    public function mail_settings()
    {
        // Return view
        return view('adminlte::settings.mail_settings');
    }

    /** Mail Settings Update */
    public function mail_settings_update(Request $request)
    {
        foreach ($request->except(array(
            '_token',
            '_method',
        )) as $key => $value) {

            $value = addslashes($value);

            // Update settings
            DB::update("update settings set value = '$value' WHERE name = '$key'");

            $this->checkbox_update('use_text_logo_in_emails', $request->get('use_text_logo_in_emails'));
            $this->checkbox_update('submission_notification_mail', $request->get('submission_notification_mail'));
            $this->checkbox_update('send_expire_notification', $request->get('send_expire_notification'));
        }

        // Check if the email logo is uploaded
        if ($request->hasFile('email_logo')) {
            $image = $request->file('email_logo');
            $filename = 'email_logo.png';
            $location = public_path('images/' . $filename);
            Image::make($image)->save($location);
        }

        // Redirect to Mail settings page
        return redirect(env('ADMIN_URL') . '/mail_settings')->with('success', __('admin.data_updated'));
    }

}
