<?php

namespace App\Jobs;

use App\Mail\Submissionreceived;
use App\Mail\Ordercomplete;
use App\Mail\Packagerenewed;
use App\Models\Translation;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;
use Shakurov\Coinbase\Models\CoinbaseWebhookCall;
use Carbon\Carbon;

class HandleConfirmedCharge implements ShouldQueue
{
    use InteractsWithQueue, Queueable, SerializesModels;

    /** @var \Shakurov\Coinbase\Models\CoinbaseWebhookCall */
    public $webhookCall;

    public function __construct(CoinbaseWebhookCall $webhookCall)
    {
        $this->webhookCall = $webhookCall;
    }

    public function handle()
    {
        // Retrieve Order Details
        $order_query = DB::table('orders')
            ->leftJoin('users', 'orders.user', '=', 'users.id')
            ->leftJoin('submissions', 'orders.submission_id', '=', 'submissions.id')
            ->leftJoin('packages', 'orders.package', '=', 'packages.id')
            ->select('users.name AS link_name', 'users.email AS link_email', 'orders.price AS price', 'orders.link_id AS link_id', 'orders.package AS package', 'orders.id AS order_id', 'orders.user AS user', 'packages.duration AS duration', 'orders.is_renewal AS is_renewal', 'orders.submission_id AS submission_id', 'submissions.category AS category', 'submissions.title AS title', 'submissions.url AS url', 'submissions.description AS description', 'submissions.ip AS ip')
            ->where('orders.payment_id', $this->webhookCall->payload['event']['data']['code'])->first();

        if ($order_query != null) {

        // Site Settings
        $site_settings = DB::table('settings')->get();

        foreach ($site_settings as $setting) {
            if ($setting->language == null) {
                $settings[$setting->name] = $setting->value;
            } else {
                $settings[$setting->name . '-' . $setting->language] = $setting->value;
            }
        }
        
        // List of languages
        $translations = Translation::orderBy('sort', 'ASC')->get();

        // Language prefixes
        foreach ($translations as $language) {
            if ($language->code == $settings['site_language']) {
                $site_language_id = $language->id;
            }
        }
        
        // Member Details
        $member = DB::table('users')->where('id', $order_query->user)->first();

        // Category Details
        $category = DB::table('categories')->where('id', $order_query->category)->first();

        $now = Carbon::now();

        $site_title = $settings['site_title'."-".$site_language_id];

        // Package Durations
        $durations = submission_durations();

        if ($order_query->is_renewal == '1') {
            $link_query = DB::table('links')->where('id', $order_query->link_id)->first();
            if ($now > $link_query->expire_at) {
                $new_expire_time = expire_time($order_query->duration, $now);
                DB::table('links')->where('id', $link_query->id)->update(['enabled' => '1', 'status' => '2']);
            } else {
                $new_expire_time = expire_time($order_query->duration, $link_query->expire_at);
            }
            DB::table('links')->where('id', $link_query->id)->update(['expire_at' => $new_expire_time]);
            DB::table('orders')->where('payment_id', $this->webhookCall->payload['event']['data']['code'])->update(['payment_status' => '1']);
            DB::table('expire_notifications')->where('link_id', '=', $link_query->id)->delete();

        // Package Details
        $package = DB::table('packages')->where('id', $link_query->package)->first();
        
        $order_details = $settings['payment_currency_symbol'] . $order_query->price . ' - ' . __('general.transaction_id') . ': ' . $this->webhookCall->payload['event']['data']['payments']['0']['transaction_id'] . ' ('.$this->webhookCall->payload['event']['data']['payments']['0']['network'].')';
        
        // Insert Notification Record
        insert_notification('4', $link_query->url);

        // Insert Order Record
        DB::table('crypto_payments')->insert(
            [
                'order_id' => $order_query->order_id,
                'network' => $this->webhookCall->payload['event']['data']['payments']['0']['network'],
                'transaction_id' => $this->webhookCall->payload['event']['data']['payments']['0']['transaction_id'],
                'create_time' => $this->webhookCall->payload['event']['data']['payments']['0']['detected_at'],
                'created_at' => \Carbon\Carbon::now()->toDateTimeString(),
            ]
        );
        
        // Notify link owner by email
        \Mail::to($order_query->link_email)->send(new Packagerenewed($durations[$order_query->duration], $settings['payment_currency_symbol'] . $order_query->price, $package->title, $link_query->url, $site_title, $_ENV['MAIL_FROM_ADDRESS']));

        } else {

        // Package Details
        $package = DB::table('packages')->where('id', $order_query->package)->first();
        
        DB::table('orders')->where('payment_id', $this->webhookCall->payload['event']['data']['code'])->update(['payment_status' => '1', 'status' => '1', 'created_at' => $now]);

        // Insert Notification Record
        insert_notification('2', $order_query->url);

        // Insert Order Record
        DB::table('crypto_payments')->insert(
            [
                'order_id' => $order_query->order_id,
                'network' => $this->webhookCall->payload['event']['data']['payments']['0']['network'],
                'transaction_id' => $this->webhookCall->payload['event']['data']['payments']['0']['transaction_id'],
                'create_time' => $this->webhookCall->payload['event']['data']['payments']['0']['detected_at'],
                'created_at' => \Carbon\Carbon::now()->toDateTimeString(),
            ]
        );
        
        // Notify link owner by email
        \Mail::to($order_query->link_email)->send(new Ordercomplete($durations[$order_query->duration], $settings['payment_currency_symbol'] . $order_query->price, $order_query->title, $order_query->url, $site_title, $_ENV['MAIL_FROM_ADDRESS']));

        // Notify site owner by email
        if ($settings['submission_notification_mail'] == '1') {
            \Mail::to($settings['admin_email'])->send(new Submissionreceived($member->name, $member->email, $package->title, $site_title, $order_query->url, $order_query->title, $order_query->description, $category->title, $order_query->ip, $_ENV['MAIL_FROM_ADDRESS']));
        }
        }
        
         $order_details = $settings['payment_currency_symbol'] . $order_query->price . ' - ' . __('admin.transaction_id') . ': ' . $this->webhookCall->payload['event']['data']['payments']['0']['transaction_id'] . ' ('.$this->webhookCall->payload['event']['data']['payments']['0']['network'].')';
        
        // Insert Notification Record
        insert_notification('3', $order_details);
        } 
    }
}
