<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class Packagerenewed extends Mailable
{
    use Queueable, SerializesModels;
    
    public $billing_cycle;
    public $price;
    public $package;
    public $url;
    public $site_title;
    public $mail_from;

    /**
     * Create a new message instance.
     *
     * @return void
     */
     public function __construct($billing_cycle, $price, $package, $url, $site_title, $mail_from)
    {
        $this->billing_cycle = $billing_cycle;
        $this->price = $price;
        $this->package = $package;
        $this->url = $url;
        $this->site_title = $site_title;
        $this->mail_from = $mail_from;

        }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from($this->mail_from)->markdown('vendor.frontend.mail.package_renewed')->subject(__('general.package_renewed'));
    }
}
