@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.comments'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- box-body -->
            <div class="box-body no-padding">

                <div class="table-responsive">
                    <table class="table table-striped" id="table" data-delete-prompt="@lang('admin.delete_prompt')" data-yes="@lang('admin.yes')" data-cancel="@lang('admin.cancel')" data-approve="@lang('admin.approve')" data-mark-unapproved="@lang('admin.mark_unapproved')">
                        <tr>
                            <th class="col-md-1">@lang('admin.id')</th>
                            <th class="col-md-3">@lang('admin.link')/@lang('admin.article')</th>
                            <th class="col-md-5">@lang('admin.comment')</th>
                            <th class="col-md-1">@lang('admin.rating')</th>
                            <th class="col-md-1">@lang('admin.status')</th>
                            <th class="col-md-1">@lang('admin.delete')</th>
                        </tr>
                        <tbody>
                            @foreach($comments as $row)
                            <tr id="{{ $row->id }}">
                                <td>{{$row->id}}</td>
                                <td><a href="@if($row->type == '1'){{ asset($language_prefix[$row->language].$settings['detail_base'.'-'.$row->language]) }}/{{ $row->slug }}@else{{ asset($language_prefix[$row->language].$settings['article_base'.'-'.$row->language]) }}/{{ $row->slug }}@endif" class="text-black" target="_blank">{{$row['app_title']}}</a></td>
                                <td><b class="d-block mb-10">{{{$row->title}}}</b>{{{$row->comment}}}<i class="d-block text-right text-muted mt-1"><b>&#65293;{{{$row->name}}}</b></i></td>
                                <td>@if($row->type == '1') {{{$row->rating}}}/5 @else - @endif</td>
                                @if ($row->approval == 0)
                                <td><a data-comment-title="{{{$row->title}}}" data-comment-details="{{{$row->comment}}}" href="{{action('App\Http\Controllers\CommentController@edit', $row['id'])}}" class="btn btn-sm bg-orange show_comment_not_approved"><i class="fas fa-spinner"></i> @lang('admin.pending')</a></td>
                                @else
                                <td><a data-comment-title="{{{$row->title}}}" data-comment-details="{{{$row->comment}}}" href="{{action('App\Http\Controllers\CommentController@edit', $row['id'])}}" class="btn btn-sm btn-primary show_comment_approved"><i class="fas fa-check"></i>
                                        @lang('admin.approved')</a></td>
                                @endif
                                <td>
                                    <form id="delete_from_{{$row->id}}" method="POST" action="{{action('App\Http\Controllers\CommentController@destroy', $row['id'])}}">
                                        {{ csrf_field() }}
                                        {{ method_field('DELETE') }}
                                        <a href="javascript:void(0);" data-id="{{$row->id}}" class="_delete_data">
                                            <span class="btn btn-sm bg-red"><i class="fas fa-ban"></i> @lang('admin.delete')</span>
                                        </a>
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

            </div>
            <!-- /.box-body -->

        </div>
        <!-- /.general form elements -->

        @if($comments->isEmpty())
        <h6 class="alert alert-danger">@lang('admin.no_record').</h6>
        @endif

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

{{ $comments->onEachSide(1)->links() }}

@endsection