@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.create_links_in_bulk'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

       @isset($fail_count) 
       <div class="alert @if($fail_count >= '1') alert-warning @else alert-success @endif">
            <p>
                @isset($fail_count)
                @if($fail_count == '0' && $success_count >= '1')
                
                {{$success_count}} links added successfully.

                 @elseif($fail_count >= '1' && $success_count >= '1')
                 
                 {{$success_count}} links added successfully, {{$fail_count}} links failed.
                 
                 @else 
                 
                 {{$fail_count}} links failed.
                 
                 @endif
                 @endif
                 </p>
        </div>
         @endif

        <!-- general form elements -->
        <div class="box">

            <!-- form -->
            <form method="POST" enctype="multipart/form-data" action="{{ Request::fullUrl() }}">
                @csrf @method('POST')

                <!-- box-body -->
                <div class="box-body">

                    <div class="form-group">
                        <label>@lang('admin.links_one_link_per_line')</label>
                        <textarea class="form-control" name="links" rows="7" placeholder="@lang('admin.links_one_link_per_line')">@isset($failed_links){{$failed_links}}@endif</textarea>
                    </div>

                </div>
                <!-- /.box-body -->

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">@lang('admin.submit')</button>
                </div>

            </form>
            <!-- /.form -->

        </div>
        <!-- /.general form elements -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection