@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.orders'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- box-body -->
            <div class="box-body no-padding">

                <div class="table-responsive">
                    <table class="table table-striped" id="table">
                        <tr>
                            <th class="col-md-1">ID</th>
                            <th class="col-md-2">@lang('admin.payment_method')</th>
                            <th class="col-md-2">@lang('admin.package')</th>
                            <th class="col-md-1">@lang('admin.price')</th>
                            <th class="col-md-2">@lang('admin.payment_status')</th>
                            <th class="col-md-1">@lang('admin.details')</th>
                            <th class="col-md-2">@lang('admin.date')</th>
                            <th class="col-md-1">@lang('admin.view')</th>
                        </tr>
                        <tbody>
                            @foreach($orders as $row)
                            <tr>
                                <td>{{$row->id}}</td>
                                <td>{{$array_data['payment_method_name'][$row->payment_method] ?? '-'}}</td>
                                <td>{{$array_data['package_name'][$row->package]}}</td>
                                <td>@if($row->price=='0.00')@lang('general.free') @else{{$row->currency_symbol}}{{$row->price}}@endif</td>
                                <td>@if($row->price == '0.00')
                                    -
                                    @else
                                    @if($row->payment_status=='0')<span class="badge not-paid">@lang('general.not_paid')</span>@endif
                                    @if($row->payment_status=='1')<span class="badge paid">@lang('general.paid')</span>@endif
                                    @if($row->payment_status=='3')<span class="badge processing">@lang('general.processing')</span>@endif
                                    @if($row->payment_status=='4')<span class="badge expired">@lang('general.expired')</span>@endif
                                    @endif
                                </td>
                                <td>{{$row->is_renewal == 1 ? __('general.renewal') : __('general.submission') }}</td>
                                <td>{{\Carbon\Carbon::parse($row->created_at)->translatedFormat('M d, Y')}}</td>
                                <td><a href="{{action('App\Http\Controllers\OrderController@edit', $row->id)}}" class="btn btn-link btn-sm bg-purple"><i class="fas fa-search"></i>
                                        @lang('admin.view')
                                    </a></td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

            </div>
            <!-- /.box-body -->

        </div>
        <!-- /.general form elements -->

        @if($orders->isEmpty())
        <h6 class="alert alert-danger">@lang('admin.no_record').</h6>
        @endif

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

{{ $orders->links()}}

@endsection