@extends('adminlte::page')

@section('content')

@if($language_menu == '0')
@section('content_header', __('admin.partners'))
@endif
@if($language_menu == '1')
@section('content_header', __('admin.languages'))
@endif

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            @if($language_menu == '1')

            <div class="table-responsive">
                <table class="table table-striped" id="table" data-delete-prompt="@lang('admin.delete_prompt')" data-yes="@lang('admin.yes')" data-cancel="@lang('admin.cancel')">
                    <thead>
                        <tr>
                            <th class="col-md-1">ID</th>
                            <th class="col-md-10">@lang('admin.language')</th>
                            <th class="col-md-1">@lang('admin.partners')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($translations as $row)
                        <tr>
                            <td>{{$row->id}}</td>
                            <td><span class="fi fi-{{$array_data['language_code'][$row->id]}}"></span> {{$row->language}}</td>
                            <td><a href="{{ asset(env('ADMIN_URL').'/partner_list/'.$row->id) }}" class="btn btn-link btn-sm bg-purple"><i class="fas fa-edit"></i>
                                    @lang('admin.view')
                                </a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            @else

            <!-- box-body -->
            <div class="box-body no-padding">

                <a href="{{ asset(env('ADMIN_URL').'/partners/create') }}" class="btn bg-purple btn-flat margin"><i class="fas fa-plus-square"></i>
                    @lang('admin.create_partner')</a>
                <div class="table-responsive">
                    <table class="table table-striped" id="table" data-delete-prompt="@lang('admin.delete_prompt')" data-yes="@lang('admin.yes')" data-cancel="@lang('admin.cancel')">
                        <tr>
                            <th class="col-md-1">ID</th>
                            <th class="col-md-8">@lang('admin.title')</th>
                            <th class="col-md-1">@lang('admin.date')</th>
                            <th class="col-md-1">@lang('admin.edit')</th>
                            <th class="col-md-1">@lang('admin.delete')</th>
                        </tr>
                        <tbody class="sortable-posts" id="partners">
                            @foreach($partners as $row)
                            <tr id="{{ $row->id }}">
                                <td>{{$row->id}}</td>
                                <td><a href="{{ $row->url }}" class="text-black" target="_blank">{{$row->title}}</a></td>
                                <td>{{\Carbon\Carbon::parse($row->created_at)->translatedFormat('M d, Y')}}</td>
                                <td><a href="{{action('App\Http\Controllers\PartnerController@edit', $row->id)}}" class="btn btn-link btn-sm bg-purple"><i class="fas fa-edit"></i>
                                        @lang('admin.edit')
                                    </a></td>
                                <td>
                                    <form id="delete_from_{{$row->id}}" method="POST" action="{{action('App\Http\Controllers\PartnerController@destroy', $row['id'])}}">
                                        {{ csrf_field() }}
                                        {{ method_field('DELETE') }}
                                        <a href="javascript:void(0);" data-id="{{$row->id}}" class="_delete_data">
                                            <span class="btn btn-sm bg-red"><i class="fas fa-ban"></i>
                                                @lang('admin.delete')</span>
                                        </a>
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

            </div>
            <!-- /.box-body -->

            @endif

        </div>
        <!-- /.general form elements -->

        @if($language_menu == '0' && $partners->isEmpty())
        <h6 class="alert alert-danger">@lang('admin.no_record').</h6>
        @endif

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection