@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.payment_notifications'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- box-body -->
            <div class="box-body no-padding">


                <div class="table-responsive">
                    <table class="table table-striped" id="table" data-delete-prompt="@lang('admin.delete_prompt')" data-yes="@lang('admin.yes')" data-cancel="@lang('admin.cancel')">
                        <tr>
                            <th class="col-md-1">@lang('admin.order_id')</th>
                            <th class="col-md-5">@lang('admin.sender_name')</th>
                            <th class="col-md-1">@lang('admin.price')</th>
                            <th class="col-md-2">@lang('admin.status')</th>
                            <th class="col-md-2">@lang('admin.date')</th>
                            <th class="col-md-1">@lang('admin.view')</th>
                        </tr>
                        <tbody>
                            @foreach($bank_payments as $row)
                            <tr>
                                <td>{{$row->order_id}}</td>
                                <td>{{$row->sender_name}}</td>
                                <td>{{$row->currency_symbol}}{{$row->price}}</td>
                                <td>
                                    @if($row->checked == '0')
                                    <span class="badge pending">@lang('admin.pending')</span>
                                    @elseif($row->checked == '1')
                                    <span class="badge approved">@lang('admin.approved')</span>
                                    @else
                                    <span class="badge rejected">@lang('admin.rejected')</span>
                                    @endif
                                </td>
                                <td>{{\Carbon\Carbon::parse($row->created_at)->translatedFormat('M d, Y')}}</td>
                                <td>@if($row->checked == '0')<a href="{{ asset(env('ADMIN_URL').'/payment_notification/'.$row->id.'') }}" class="btn btn-link btn-sm bg-purple"><i class="fas fa-search"></i>@lang('admin.view')</a>@else<span class="bg-checked"><i class="fas fa-search"></i>@lang('admin.view')</span>@endif</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

            </div>
            <!-- /.box-body -->

        </div>
        <!-- /.general form elements -->

        @if($bank_payments->isEmpty())
        <h6 class="alert alert-danger">@lang('admin.no_record').</h6>
        @endif

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

{{ $bank_payments->onEachSide(1)->links() }}

@endsection