@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.pwa_settings'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- form -->
            <form method="POST" enctype="multipart/form-data" action="{{url(env('ADMIN_URL').'/pwa_settings/')}}">
                @csrf @method('POST')

                <!-- box-body -->
                <div class="box-body">

                    <!-- row -->
                    <div class="row">
                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.pwa_settings')</label>
                        </div>
                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <div class="form-group">
                                <label>@lang('admin.enable_pwa') </label><br />
                                <input type="checkbox" name="enable_pwa" {{ $settings['enable_pwa'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label>@lang('admin.pwa_name') <span class="text-danger">*</span></label>
                                <input type="text" name="pwa_name" class="form-control" value="{{$settings['pwa_name']}}" placeholder="@lang('admin.pwa_name')" />
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label>@lang('admin.pwa_short_name') <span class="text-danger">*</span></label>
                                <input type="text" name="pwa_short_name" class="form-control" value="{{$settings['pwa_short_name']}}" placeholder="@lang('admin.pwa_short_name')" />
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label>@lang('admin.pwa_description') <span class="text-danger">*</span></label>
                                <input type="text" name="pwa_description" class="form-control" value="{{$settings['pwa_description']}}" placeholder="@lang('admin.pwa_description')" />
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>@lang('admin.pwa_theme_color') <span class="text-danger">*</span></label>
                                <input type="text" name="pwa_theme_color" class="form-control my-colorpicker" value="{{$settings['pwa_theme_color']}}" placeholder="@lang('admin.pwa_theme_color')" />
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>@lang('admin.pwa_background_color') <span class="text-danger">*</span></label>
                                <input type="text" name="pwa_background_color" class="form-control my-colorpicker" value="{{$settings['pwa_background_color']}}" placeholder="@lang('admin.pwa_background_color')" />
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>@lang('admin.pwa_screenshot')<br /><span class="label bg-dark">1080x1920</span></label>
                                <div class="logo-box mt-5">
                                    <img src="{{ asset('/images/pwa-screenshot.png') }}?r={{Str::random(40)}}" class="img-responsive">
                                </div>
                                <label class="btn btn-outline btn-sm" id="browse-color-image">@lang('admin.browse')<input type="file" name="pwa_screenshot" id="import-file-select" class="hidden"></label>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>@lang('admin.pwa_icon')<br /><span class="label bg-dark">512x512</span></label>
                                <div class="logo-box mt-5">
                                    <img src="{{ asset('/images/pwa-512x512.png') }}?r={{Str::random(40)}}" class="img-responsive">
                                </div>
                                <label class="btn btn-outline btn-sm" id="browse-color-image">@lang('admin.browse')<input type="file" name="pwa_512" id="import-file-select" class="hidden"></label>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>@lang('admin.pwa_icon')<br /><span class="label bg-dark">192x192</span></label>
                                <div class="logo-box mt-5">
                                    <img src="{{ asset('/images/pwa-192x192.png') }}?r={{Str::random(40)}}" class="img-responsive">
                                </div>
                                <label class="btn btn-outline btn-sm" id="browse-color-image">@lang('admin.browse')<input type="file" name="pwa_192" id="import-file-select" class="hidden"></label>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>@lang('admin.pwa_icon')<br /><span class="label bg-dark">48x48</span></label>
                                <div class="logo-box mt-5">
                                    <img src="{{ asset('/images/pwa-48x48.png') }}?r={{Str::random(40)}}" class="img-responsive">
                                </div>
                                <label class="btn btn-outline btn-sm" id="browse-color-image">@lang('admin.browse')<input type="file" name="pwa_48" id="import-file-select" class="hidden"></label>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>@lang('admin.pwa_icon')<br /><span class="label bg-dark">24x24</span></label>
                                <div class="logo-box mt-5">
                                    <img src="{{ asset('/images/pwa-24x24.png') }}?r={{Str::random(40)}}" class="img-responsive">
                                </div>
                                <label class="btn btn-outline btn-sm" id="browse-color-image">@lang('admin.browse')<input type="file" name="pwa_24" id="import-file-select" class="hidden"></label>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                </div>
                <!-- /.box-body -->

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">@lang('admin.submit')</button>
                </div>

            </form>
            <!-- /.form -->

        </div>
        <!-- /.general form elements -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection
