@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.edit_translation'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements general -->
        <div class="box">

            <ul class="nav nav-tabs" id="myTab" role="tablist">
                <li class="nav-item active">
                    <a class="nav-link text-black" id="language-tab" data-toggle="tab" href="#language" role="tab" aria-controls="language" aria-selected="true">@lang('admin.language_details')</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link text-black" id="frontend-tab" data-toggle="tab" href="#frontend" role="tab" aria-controls="frontend" aria-selected="false">@lang('admin.frontend')</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link text-black" id="dashboard-tab" data-toggle="tab" href="#dashboard" role="tab" aria-controls="dashboard" aria-selected="false">@lang('admin.dashboard')</a>
                </li>
            </ul>

            <!-- Tab panes -->
            <div class="tab-content">

                <div class="tab-pane active" id="language" role="tabpanel" aria-labelledby="language-tab">

                    <!-- form -->
                    <form method="POST" id="form_1" enctype="multipart/form-data" action="{{action('App\Http\Controllers\TranslationController@update', $id)}}">
                        @csrf @method('PUT')

                        <input name="translation_type" type="hidden" value="1">

                        <!-- box-body -->
                        <div class="box-body">

                            <div class="row mb-10">
                                <div class="col-md-3">
                                    <label>@lang('admin.language') <span class="text-danger">*</span></label>
                                </div>
                                <div class="col-md-9">
                                    <input type="text" name="language" class="form-control" value="{{$translation->language}}" placeholder="@lang('admin.language')" @if ($translation->code == 'en')readonly @endif/>
                                </div>
                            </div>

                            <div class="row mb-10">
                                <div class="col-md-3">
                                    <label>@lang('admin.language_code') <span class="text-danger">*</span></label>
                                </div>
                                <div class="col-md-9">
                                    <input type="text" name="code" class="form-control" value="{{$translation->code}}" placeholder="@lang('admin.language_code')" @if ($translation->code == 'en')readonly @endif/>
                                </div>
                            </div>

                            <div class="row mb-10">
                                <div class="col-md-3">
                                    <label>@lang('admin.og_locale_tag') <span class="text-danger">*</span></label>
                                </div>

                                <div class="col-md-9">
                                    <input type="text" name="locale_code" class="form-control" value="{{$translation->locale_code}}" placeholder="@lang('admin.og_locale_tag')" />
                                </div>
                            </div>

                            <div class="row mb-10">
                                <div class="col-md-3">
                                    <label>@lang('admin.country_flag') <span class="text-danger">*</span></label>
                                </div>
                                <div class="col-md-9">
                                    <select title="@lang('admin.select_flag')" name="icon" class="form-control selectpicker" data-live-search="true">
                                        @foreach($countries as $country)
                                        <option value="{{$country['code']}}" data-content="<span class='fi fi-{{$country['code']}}'></span> {{$country['name']}}" {{ $translation->icon == $country['code'] ? ' selected' : '' }}></option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="row mb-10">
                                <div class="col-md-3">
                                    <label>@lang('admin.text_direction') <span class="text-danger">*</span></label>
                                </div>
                                <div class="col-md-9">
                                    <select title="@lang('admin.navbar_type')" name="text_direction" class="form-control selectpicker" data-live-search="true">
                                        <option value="1" {{ $translation->text_direction == '1' ? ' selected' : '' }}>@lang('admin.ltr')</option>
                                        <option value="2" {{ $translation->text_direction == '2' ? ' selected' : '' }}>@lang('admin.rtl')</option>
                                    </select>
                                </div>
                            </div>

                            <div class="row mb-10">
                                <div class="col-md-3">
                                    <label>@lang('admin.hidden_on_header')</label><br />
                                </div>

                                <div class="col-md-9">
                                    <input type="checkbox" name="hidden" {{ $translation->hidden == 1 ? 'checked' : '' }}>
                                </div>
                            </div>

                        </div>
                        <!-- /.box-body -->

                        <div class="box-footer">
                            <button type="submit" class="btn btn-primary">@lang('admin.submit')</button>
                        </div>

                    </form>
                    <!-- /.form -->

                </div>

                <div class="tab-pane" id="frontend" role="tabpanel" aria-labelledby="frontend-tab">

                    <!-- form -->
                    <form method="POST" id="form_2" enctype="multipart/form-data" action="{{action('App\Http\Controllers\TranslationController@update', $id)}}">
                        @csrf @method('PUT')

                        <input name="translation_type" type="hidden" value="2">

                        <!-- box-body -->
                        <div class="box-body">

                            @foreach($translation_frontend_org as $key => $item)
                            @if ($loop->first) @continue @endif
                            <div class="row mb-10">
                                <div class="col-md-3">
                                    <label>{{$key}}</label>
                                </div>
                                <div class="col-md-9">
                                    <input type="text" name="{{$key}}" class="form-control" value="{{$translation_frontend_target[$key]}}" placeholder="{{$translation_frontend_target[$key]}}" />
                                </div>
                            </div>
                            @endforeach

                        </div>
                        <!-- /.box-body -->

                        <div class="box-footer">
                            <button type="submit" class="btn btn-primary">@lang('admin.submit')</button>
                        </div>

                    </form>
                    <!-- /.form -->

                </div>

                <div class="tab-pane" id="dashboard" role="tabpanel" aria-labelledby="dashboard-tab">

                    <!-- form -->
                    <form method="POST" id="form_2" enctype="multipart/form-data" action="{{action('App\Http\Controllers\TranslationController@update', $id)}}">
                        @csrf @method('PUT')

                        <input name="translation_type" type="hidden" value="3">

                        <!-- box-body -->
                        <div class="box-body">

                            @foreach($translation_admin_org as $key => $item)
                            @if ($loop->first) @continue @endif
                            <div class="row mb-10">
                                <div class="col-md-3">
                                    <label>{{$key}}</label>
                                </div>
                                <div class="col-md-9">
                                    <input type="text" name="{{$key}}" class="form-control" value="{{$translation_admin_target[$key]}}" placeholder="{{$translation_admin_target[$key]}}" />
                                </div>
                            </div>
                            @endforeach

                        </div>
                        <!-- /.box-body -->

                        <div class="box-footer">
                            <button type="submit" class="btn btn-primary">@lang('admin.submit')</button>
                        </div>

                    </form>
                    <!-- /.form -->

                </div>

            </div>

        </div>
        <!-- /.general form elements general -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection