@extends('frontend::page')

@section('content')

<!-- Container -->
<main class="container links mt-3">

    <!-- Grid Row -->
    <div class="row">

        <!-- Grid Column -->
        <div class="col-md-9">

            @if(!empty($ad[4]))<div class="mb-3 text-center">{!! $ad[4] !!}</div>@endif

            <!-- Search Box -->
            @include('frontend::inc.partials', ['type' => '1'])
            <!-- /Search Box -->

            @if ($settings['breadcrumbs'] == '1')
            <!-- Breadcrumbs -->
            <div class="breadcrumbs mb-3">
                <a href="{{ asset($language_prefix) }}">@lang('general.homepage')</a> <span class="sep">›</span>
                <a href="{{url()->current()}}">@lang('general.favorites')</a>
            </div>

            @if ($settings['schema_breadcrumbs'] == '1')
            {!! $breadcrumb_schema_data->toScript() !!}
            @endif
            <!-- /Breadcrumbs -->
            @endif

            @if($links->isEmpty())
            <div class="col-12">
                <h6 class="alert alert-warning">@lang('general.no_favorites')</h6>
            </div>
            @else

            <a href="?clear" class="clear-button text-white btn mb-3">@lang('general.clear_favorites')</a>

            <!-- Links -->
            @foreach ($links as $link)

            @if(empty($link->image))
            @php $link->image='no_image.png'; @endphp
            @endif

            <div class="col-12 mb-3">
                <div class="shadow-sm p-2 bg-white rounded">
                    <div class="row p-1">
                        <a href="@if ($link->bypass_details == '0'){{ asset($language_prefix.$settings['detail_base']) }}/{{ $link->slug }}@else{{ $link->url }}@endif" @if ($link->bypass_details == '1') target="_blank"{!! $link_types[$link->bypass_details_type] !!}@endif>
                            <div class="d-flex">
                                <div class="me-2">
                                    <img src="{{ asset('images/pixel.png') }}" data-src="{{ asset('images/links') }}/{{ $link->image }}" class="site-icon rounded lazy" alt="{{ $link->title }}">
                                    <noscript>
                                        <img src="{{ asset('images/links') }}/{{ $link->image }}" class="site-icon rounded" alt="{{ $link->title }}" />
                                    </noscript>
                                </div>
                                <div class="ps-1 my-md-0 my-auto">
                                    <span class="link-title">{{ $link->title }}</span>@if($link->badge == '1') <i class="icon-check-circle title-badge" data-bs-toggle="tooltip" data-bs-placement="top" title="@lang('general.badge_title')"></i>@endif
                                    <div>
                                        {!!stars($link->votes, 2, 1)!!}
                                    </div>
                                    <p class="description m-0">{{{ $link->description }}}</p>
                                    <span class="site-url">
                                        @if(empty($link->visible_url))
                                        {{ $link->url }}
                                        @else
                                        {{ $link->visible_url }}
                                        @endif
                                    </span>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>

            @endforeach
            @endif
            <!-- /Links -->

            @if(!empty($ad[3]))<div class="mb-3 text-center">{!! $ad[3] !!}</div>@endif

        </div>
        <!-- /Grid Column -->

        <!-- Grid Column -->
        <div class="col-md-3 text-center mb-3">
            @if ($settings['sticky_ads_right_column'] == '1')<div class="sticky-top sticky-top-15">@endif
                @if(!empty($ad[5]))<div class="mb-3">{!! $ad[5] !!}</div>@endif
                @if ($settings['sticky_ads_right_column'] == '1')</div>@endif
        </div>
        <!-- /Grid Column -->

    </div>
    <!-- /Grid Row -->

</main>
<!-- /Container -->

@endsection
