@extends('frontend::page')

@section('content')

<!-- Container -->
<main class="container">

    <!-- Grid Row -->
    <div class="row my-md-2 my-4 mx-1">

        <main class="form-signin bg-white shadow-sm rounded my-md-3 p-3">

            <form method="POST" action="{{ asset($language_prefix.'member-area/login') }}">
                @csrf

                <span class="h5 fw-bold">@lang('general.welcome_back')</span>

                @if ($settings['enable_registration'] == '1')
                <div class="sign-up mt-1">
                    @lang('general.dont_have_account') <a href="{{ asset($language_prefix.'member-area/register') }}">@lang('general.sign_up')</a>
                </div>
                @endif

                @if(count($errors) > 0)
                <div class="alert alert-danger login-alert mt-2" role="alert">
                    @foreach($errors->all() as $error)
                    <p><b>@lang('general.error'):</b> {{$error}}</p>
                    @endforeach
                </div>
                @endif @if(Session::has('success'))
                <div class="alert alert-success login-alert mt-2">
                    <p>{{ Session::get('success') }}</p>
                </div>
                @endif

                <div class="mt-3">
                    <input type="email" name="email" class="form-control text-field" placeholder="@lang('general.email_address')">
                </div>
                <div class="mt-2">
                    <input type="password" name="password" class="form-control text-field" placeholder="@lang('general.password')">
                </div>

                <div class="form-check checkbox my-2">
                    <input class="form-check-input" type="checkbox" name="remember_me" id="flexCheckDefault">
                    <label class="form-check-label" for="flexCheckDefault">
                        @lang('general.remember_me')
                    </label>
                    <a href="{{ asset($language_prefix.'member-area/password-reset') }}" class="float-end">@lang('general.forgot_password')</a>
                </div>

                @if ($settings['enable_google_recaptcha'] == '1')
                <div class="g-recaptcha mb-3 mt-2" data-sitekey="{{ $settings['google_recaptcha_site_key'] }}"></div>
                @endif

                <button class="w-100 btn" type="submit">@lang('general.sign_in') <i class="icon-sign-in"></i></button>
            </form>
        </main>

    </div>
    <!-- /Grid row -->

</main>
<!-- /Container -->

@endsection