@extends('frontend::page')

@section('content')

@foreach ($packages as $package)
@php $package_name[$package->id]=$package->title; @endphp
@endforeach
@foreach ($payment_methods as $method)
@php $payment_method[$method->id]=__('general.'.$method->title.''); @endphp
@endforeach


<!-- Container -->
<main class="container">

    <!-- Grid Row -->
    <div class="row member-area mt-3">

        <div class="col-md-3 menu">

            <div class="bg-white shadow-sm rounded p-2 pb-0">
                <!-- Left Column -->
                @include('frontend::inc.partials', ['type' => '3'])
                <!-- /Left Column -->
            </div>

        </div>

        <div class="col-md-9 mb-3">

            <div class="bg-white shadow-sm rounded px-2">

                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <tbody>
                            <tr>
                                <th>@lang('general.order_id'):</th>
                                <td>#{{ $order_query->id }}</td>
                            </tr>
                            <tr>
                                <th>@lang('general.status')</th>
                                <td>
                                    {{-- Bank Payments --}}
                                    @if($order_query->payment_method == '2')
                                    @if($order_query->payment_status=='0')<span class="badge not-paid">@lang('general.not_paid')</span> <a href="{{ asset($language_prefix.'member-area/payment-notification/'.$order_query->id.'') }}" class="badge pay-now">@lang('general.payment_notification')</a>@endif
                                    @if($order_query->payment_status=='1')<span class="badge paid">@lang('general.paid')</span>@endif
                                    @endif

                                    {{-- PayPal --}}
                                    @if($order_query->payment_method == '1' || $order_query->payment_method == '5')
                                    @if($order_query->payment_status == '0')<span class="badge not-paid">@lang('general.not_paid')</span>@endif
                                    @if($order_query->payment_status == '1')<span class="badge paid">@lang('general.paid')</span>@endif
                                    @if($order_query->payment_status == '2')<span class="badge pending">@lang('general.processing_subscription')</span>@endif

                                    @if($_ENV['PAYPAL_MODE'] == 'live' && $order_query->payment_method=='1' && $order_query->payment_status=='0')<a href="https://www.paypal.com/checkoutnow?token={{$order_query->payment_id}}" target="_blank" class="badge pay-now">@endif
                                        @if($_ENV['PAYPAL_MODE'] == 'sandbox' && $order_query->payment_method=='1' && $order_query->payment_status=='0')<a href="https://www.sandbox.paypal.com/checkoutnow?token={{$order_query->payment_id}}" target="_blank" class="badge pay-now">@lang('general.pay_now')</a>
                                        @endif

                                        @if($_ENV['PAYPAL_MODE'] == 'live' && $order_query->payment_method=='5' && $order_query->payment_status=='0')<a href="https://www.paypal.com/webapps/billing/subscriptions?ba_token={{$order_query->subscription_token}}" target="_blank" class="badge pay-now">@endif
                                            @if($_ENV['PAYPAL_MODE'] == 'sandbox' && $order_query->payment_method=='5' && $order_query->payment_status=='0')<a href="https://www.sandbox.paypal.com/webapps/billing/subscriptions?ba_token={{$order_query->subscription_token}}" target="_blank" class="badge pay-now">@lang('general.pay_now')</a>@endif
                                            @endif

                                            {{-- Stripe --}}
                                            @if($order_query->payment_method == '3')
                                            @if($order_query->payment_status == '0')<span class="badge not-paid">@lang('general.not_paid')</span> <a href="{{ asset($language_prefix.'member-area/stripe-payment/'.$order_query->id.'') }}" class="badge pay-now">@lang('general.pay_now')</a>@endif
                                            @if($order_query->payment_status == '1')<span class="badge paid">@lang('general.paid')</span>@endif
                                            @endif

                                            {{-- Coinbase --}}
                                            @if($order_query->payment_method == '4')
                                            @if($order_query->payment_status == '0')<span class="badge not-paid">@lang('general.not_paid')</span> <a href="https://commerce.coinbase.com/charges/{{$order_query->payment_id}}" target="_blank" class="badge pay-now">@lang('general.pay_now')</a>@endif
                                            @if($order_query->payment_status == '1')<span class="badge paid">@lang('general.paid')</span>@endif
                                            @if($order_query->payment_status == '3')<span class="badge processing">@lang('general.processing')</span>@endif
                                            @if($order_query->payment_status == '4')<span class="badge expired">@lang('general.expired')</span>@endif
                                            @endif

                                            {{-- Pending Approval --}}
                                            @if($order_query->status=='1')<span class="badge pending">@lang('general.pending_approval')</span>@endif

                                            {{-- Pending Approval --}}
                                            @if($order_query->status=='2')<span class="badge approved">@lang('general.approved')</span>@endif

                                            {{-- Denied --}}
                                            @if($order_query->status=='3')<span class="badge rejected">@lang('general.rejected')</span>@endif
                                </td>
                            </tr>
                            <tr>
                                <th>@lang('general.title')</th>
                                <td>{{ $order_query->title }}</td>
                            </tr>
                            <tr>
                                <th>@lang('general.url')</th>
                                <td>{{ $order_query->url }}</td>
                            </tr>
                            <tr>
                                <th>@lang('general.package')</th>
                                <td>{{ $package_name[$order_query->package] }}</td>
                            </tr>
                            <tr>
                                <th>@lang('general.price')</th>
                                <td>@if($order_query->price=='0.00')@lang('general.free') @else{{$order_query->currency_symbol}}{{$order_query->price}}@endif</td>
                            </tr>
                            @if($order_query->price!='0.00')
                            <tr>
                                <th>@lang('general.payment_method')</th>
                                <td>{{ $payment_method[$order_query->payment_method] }}</td>
                            </tr>
                            @endif
                            <tr>
                                <th>@lang('general.date')</th>
                                <td>{{\Carbon\Carbon::parse($order_query->created_at)->translatedFormat('F d, Y H:i:s')}}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>

            </div>

        </div>

    </div>
    <!-- /Grid row -->

</main>
<!-- /Container -->

@endsection