@extends('frontend::page')

@section('content')

<!-- Container -->
<main class="container">

    <!-- Grid Row -->
    <div class="row my-md-2 my-4 mx-1">

        <main class="form-signin bg-white shadow-sm rounded my-md-3 p-3">

            <span class="h5 fw-bold">@lang('general.forgotten_your_password')</span>

            <div class="sign-up mt-1">
                @lang('general.forgotten_your_password_description')
            </div>

            @if(Session::has('success'))
            <div class="alert alert-success login-alert mt-2 mb-0">
                <p>{{ Session::get('success') }}</p>
            </div>

            @else

            <form method="POST" action="{{ asset($language_prefix.'member-area/password-reset') }}">
                @csrf

                @if(count($errors) > 0)
                <div class="alert alert-danger login-alert mt-2" role="alert">
                    @foreach($errors->all() as $error)
                    <p><b>@lang('general.error'):</b> {{$error}}</p>
                    @endforeach
                </div>
                @endif

                <div class="mt-2 mb-2">
                    <input type="email" name="email" class="form-control text-field" placeholder="@lang('general.email_address')">
                </div>

                @if ($settings['enable_google_recaptcha'] == '1')
                <div class="g-recaptcha" data-sitekey="{{ $settings['google_recaptcha_site_key'] }}"></div>
                @endif

                <button class="w-100 btn mt-2" type="submit">@lang('general.request_password_reset') <span class="icon-chevron-right"></span></button>
            </form>

            @endif

        </main>

    </div>
    <!-- /Grid row -->

</main>
<!-- /Container -->

@endsection