@extends('rtl-frontend::page')

@section('content')

<!-- Container -->
<main class="container">

    <!-- Grid Row -->
    <div class="row member-area mt-3">

        <div class="col-md-3 menu">

            <div class="bg-white shadow-sm rounded p-2 pb-0">
                <!-- Left Column -->
                @include('rtl-frontend::inc.partials', ['type' => '3'])
                <!-- /Left Column -->
            </div>

        </div>

        <div class="col-md-9 mb-3">

            <div class="bg-white shadow-sm rounded p-2">

                <div class="p-1">

                    @if(count($errors) > 0)
                    <div class="alert alert-danger login-alert" role="alert">
                        @foreach($errors->all() as $error)
                        <p><b>@lang('general.error'):</b> {{$error}}</p>
                        @endforeach
                    </div>
                    @endif @if(Session::has('success'))
                    <div class="alert alert-success login-alert">
                        <p>{{ Session::get('success') }}</p>
                    </div>
                    @endif

                    <form method="POST" action="{{ asset($language_prefix.'member-area/my-account') }}">
                        @csrf

                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.full_name') <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control" value="{{$member->name}}">
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.email_address')</label>
                            <input type="email" class="form-control" value="{{$member->email}}" readonly>
                            <small class="text-muted">@lang('general.email_cannot_changed')</small>
                        </div>

                        <div class="border-top pt-3">

                            <span class="fw-bold h6">@lang('general.password_change')</span><br />
                            <small class="text-muted">@lang('general.leave_blank_to_unchanged')</small>

                            <div class="mb-3 mt-3">
                                <label class="form-label fw-bold">@lang('general.current_password')</label>
                                <input type="password" name="current_password" class="form-control">
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-bold">@lang('general.new_password')</label>
                                <input type="password" name="new_password" class="form-control">
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-bold">@lang('general.confirm_new_password')</label>
                                <input type="password" name="new_password_confirmation" class="form-control">
                            </div>

                        </div>

                        <button class="btn update-btn" type="submit">@lang('general.save_changes')</button>

                    </form>

                </div>

            </div>

        </div>

    </div>
    <!-- /Grid row -->

</main>
<!-- /Container -->

@endsection