@extends('rtl-frontend::page')

@section('content')

<!-- Container -->
<main class="container">

    <!-- Grid Row -->
    <div class="row my-md-2 my-4 mx-1">

        <main class="form-signin bg-white shadow-sm rounded my-md-3 p-3">

            <span class="h5 fw-bold">@lang('general.create_free_account')</span>

            <div class="sign-up mt-1">
                @lang('general.already_have_account') <a href="{{ asset($language_prefix.'member-area/login') }}">@lang('general.sign_in')</a>
            </div>

            @if(Session::has('success'))
            <div class="alert alert-success login-alert mt-2 mb-0">
                <p>{{ Session::get('success') }}</p>
            </div>

            @else

            <form method="POST" action="{{ asset($language_prefix.'member-area/register') }}">
                @csrf

                @if(count($errors) > 0)
                <div class="alert alert-danger login-alert mt-2" role="alert">
                    @foreach($errors->all() as $error)
                    <p><b>@lang('general.error'):</b> {{$error}}</p>
                    @endforeach
                </div>
                @endif @if(Session::has('success'))
                <div class="alert alert-success login-alert mt-2">
                    <p>{{ Session::get('success') }}</p>
                </div>
                @endif

                <div class="mt-3">
                    <input type="text" name="name" class="form-control text-field" placeholder="@lang('general.full_name')">
                </div>

                <div class="mt-2">
                    <input type="email" name="email" class="form-control text-field" placeholder="@lang('general.email_address')">
                </div>

                <div class="mt-2">
                    <input type="password" name="password" class="form-control text-field" placeholder="@lang('general.password')">
                </div>

                <div class="mt-2">
                    <input type="password" name="password_confirmation" class="form-control text-field" placeholder="@lang('general.confirm_password')">
                </div>

                <div class="form-check checkbox my-2">
                    <input class="form-check-input" type="checkbox" name="terms" id="flexCheckDefault">
                    <label class="form-check-label" for="flexCheckDefault">
                        @lang('general.accept_terms_conditions')
                    </label>
                </div>

                @if ($settings['enable_google_recaptcha'] == '1')
                <div class="g-recaptcha mb-3 mt-2" data-sitekey="{{ $settings['google_recaptcha_site_key'] }}"></div>
                @endif

                <button class="w-100 btn" type="submit">@lang('general.sign_up') <i class="icon-user"></i></button>
            </form>

            @endif

        </main>

    </div>
    <!-- /Grid row -->

</main>
<!-- /Container -->

@endsection