// Social media share
function sm_share(url, title, w, h) {
  "use strict";

  var dualScreenLeft =
    window.screenLeft != undefined ? window.screenLeft : screen.left;
  var dualScreenTop =
    window.screenTop != undefined ? window.screenTop : screen.top;

  var width = window.innerWidth
    ? window.innerWidth
    : document.documentElement.clientWidth
    ? document.documentElement.clientWidth
    : screen.width;
  var height = window.innerHeight
    ? window.innerHeight
    : document.documentElement.clientHeight
    ? document.documentElement.clientHeight
    : screen.height;

  var left = width / 2 - w / 2 + dualScreenLeft;
  var top = height / 2 - h / 2 + dualScreenTop;
  var newWindow = window.open(
    url,
    title,
    "scrollbars=yes, width=" +
      w +
      ", height=" +
      h +
      ", top=" +
      top +
      ", left=" +
      left
  );

  if (window.focus) {
    newWindow.focus();
  }
}

// Redirections
$(document).ready(function () {
  "use strict";

  if (document.getElementById("redirect")) {
    var id_data = document.getElementById("redirect");
    var redirect_base = id_data.getAttribute("data-redirect-base");
    var app_delay = id_data.getAttribute('data-redirection-delay');
    
    if (window.location.href.indexOf(redirect_base) > -1) {

      let time = (app_delay / 1000) - 1;
      let countdown = setInterval(update, 1000)

      function update() {
          let min = Math.floor(time);
          let sec = time;
          document.getElementById("countdown").innerHTML = `(${sec})`;
          time--;
          min == 0 && sec == 0 ? clearInterval(countdown) : countdown;
      }

      var link_id = id_data.getAttribute("data-app-id");
      var app_delay = id_data.getAttribute("data-redirection-delay");

      window.setTimeout(function () {
        window.location.href = "../link-redirect/" + link_id + "";
      }, app_delay);
    }
  }
});

// Validate Email
function validateEmail($email) {
  "use strict";

  var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
  return emailReg.test($email);
}

// Comment Form Control
function form_control() {
  "use strict";

  var name = $.trim($('#name').val());
  var email = $.trim($('#email').val());
  var title = $.trim($('#title').val());
  var comment = $.trim($('#comment').val());
  if (document.getElementById("rating")) {
      var voting_data = document.getElementById('rating');
      var rating_id = voting_data.getAttribute('data-rating-id');
      var type = 1;
  } else {
      var type = 2;
  }
  var comment_data = document.getElementById('comment-section');
  var fill_all_fields = comment_data.getAttribute('data-fill-all-fields');

  if (validateEmail(email) && name != "" && title != "" && comment != "") {
      comment_send(type);
  } else {
      $('#comment_result').html('<div class="alert alert-danger show mt-3 mb-2" role="alert">' + fill_all_fields + '');
  }
}
// Post Comment
function comment_send() {
  "use strict";

  $.ajax({
    headers: {
      "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
    },
    type: "POST",
    url: "../comment",
    data: $("#comment-form").serialize(),
    success: function (msg) {
      $("#comment-section :input").prop("disabled", true);
      $("#comment_result").html(msg);
      $("#comment-form")[0].reset();
    },
  });
}

// Link Submission Form Control
function link_submission_form() {
  "use strict";

  var name = $.trim($("#name").val());
  var email = $.trim($("#email").val());
  var title = $.trim($("#title").val());
  var url = $.trim($("#url").val());
  var description = $.trim($("#description").val());
  var category = $.trim($("#category").val());
  var image = $.trim($("#image").val());

  link_submission_send();
}

// Link Submission
function link_submission_send() {
  "use strict";

  var frm = $("#link-submission-form");
  var formData = new FormData(frm[0]);
  try {
    var recaptcha = grecaptcha.getResponse();
    formData.append("recaptcha", recaptcha);
  } catch (e) {}

  var submission_data = document.getElementById("link-submission-section");
  var data_error = submission_data.getAttribute("data-error");
  var data_recaptcha_error = submission_data.getAttribute(
    "data-recaptcha-error"
  );

  const recaptcha_errors = [
    "missing-input-secret",
    "invalid-input-secret",
    "missing-input-response",
    "invalid-input-response",
    "bad-request",
    "timeout-or-duplicate",
  ];

  $.ajax({
    headers: {
      "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
    },
    type: "POST",
    enctype: "multipart/form-data",
    url: "link-submission",
    data: formData,
    processData: false,
    contentType: false,
    success: function (msg) {
      $("#link-submission-form")[0].reset();
      $(".g-recaptcha").remove();
      $("#link-submission-section :input").prop("disabled", true);
      $("#link-submission-result").html(msg);
    },
    error: function (xhr) {
      $.each(xhr.responseJSON.errors, function (key, value) {
        if (recaptcha_errors.indexOf(value) > -1) {
          grecaptcha.reset();
          $("#link-submission-result").html(
            '<div class="alert alert-danger mt-3 show" role="alert"><b>' +
              data_error +
              ":</b> " +
              data_recaptcha_error +
              "</div"
          );
          return false;
        }

        $("#link-submission-result").html(
          '<div class="alert alert-danger mt-3 show" role="alert"><b>' +
            data_error +
            ":</b> " +
            value +
            "</div"
        );
        return false;
      });
    },
  });
}

// Report Submission Form Control
function report_submission_form() {
  "use strict";

  var name = $.trim($("#name").val());
  var email = $.trim($("#email").val());
  var reason = $.trim($("#reason").val());

  report_submission_send();
}

// Report Submission
function report_submission_send() {
  "use strict";

  var frm = $("#report-submission-form");
  var formData = new FormData(frm[0]);
  try {
    var recaptcha = grecaptcha.getResponse();
    formData.append("recaptcha", recaptcha);
  } catch (e) {}

  var submission_data = document.getElementById("report-submission-section");
  var data_error = submission_data.getAttribute("data-error");
  var data_recaptcha_error = submission_data.getAttribute(
    "data-recaptcha-error"
  );

  const recaptcha_errors = [
    "missing-input-secret",
    "invalid-input-secret",
    "missing-input-response",
    "invalid-input-response",
    "bad-request",
    "timeout-or-duplicate",
  ];

  $.ajax({
    headers: {
      "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
    },
    type: "POST",
    url: "../report-link",
    data: formData,
    processData: false,
    contentType: false,
    success: function (msg) {
      $("#report-submission-form")[0].reset();
      $(".g-recaptcha").remove();
      $("#report-submission-section :input").prop("disabled", true);
      $("#report-submission-result").html(msg);
    },
    error: function (xhr) {
      $.each(xhr.responseJSON.errors, function (key, value) {
        if (recaptcha_errors.indexOf(value) > -1) {
          grecaptcha.reset();
          $("#report-submission-result").html(
            '<div class="alert alert-danger mt-3 show" role="alert"><b>' +
              data_error +
              ":</b> " +
              data_recaptcha_error +
              "</div"
          );
          return false;
        }

        $("#report-submission-result").html(
          '<div class="alert alert-danger mt-3 show" role="alert"><b>' +
            data_error +
            ":</b> " +
            value +
            "</div"
        );
        return false;
      });
    },
  });
}

// Report Submission Form Control
function contact_form() {
  "use strict";

  var name = $.trim($("#name").val());
  var email = $.trim($("#email").val());
  var subject = $.trim($("#subject").val());
  var message = $.trim($("#message").val());

  contact_form_send();
}

// Apps star ratings
$(function () {
  "use strict";

  var base_url = document
    .querySelector("meta[property='base_url']")
    .getAttribute("content");

  $(".ratings").rating(function (vote, event, data_vote_id) {
    $.ajax({
      headers: {
        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
      },
      url: "" + base_url + "/vote/" + data_vote_id + "",
      type: "POST",
      data: {
        vote: vote,
      },
      success: function (data) {
        $(".vote_info").fadeIn("slow");
        $(".vote_info").html(data);
        $(".vote_info").delay(2000).fadeOut("slow");
      },
    });
  });
});

// Comment & Review form apps star ratings
$(function () {
  "use strict";

  $(".user_ratings").rating(function () {});
});

// Smooth Scroll
$(document).ready(function() {
  "use strict";

  $(".add-comment").click(function() {
      event.preventDefault();
      document.querySelector(".comment-box").style.display = "block";
      scrollSmoothTo('review-title');
  });
});

// Smooth Scroll
$(document).ready(function () {
  "use strict";

  $(".review-title a").click(function () {
    event.preventDefault();
    document.querySelector(".comment-box").style.display = "block";
    scrollSmoothTo("review-title");
  });
});

function scrollSmoothTo(elementId) {
  "use strict";

  var element = document.getElementById(elementId);
  element.scrollIntoView({
    block: "start",
    behavior: "smooth",
  });
}

// Report Submission
function contact_form_send() {
  "use strict";

  var frm = $("#contact-form");
  var formData = new FormData(frm[0]);
  try {
    var recaptcha = grecaptcha.getResponse();
    formData.append("recaptcha", recaptcha);
  } catch (e) {}

  var submission_data = document.getElementById("contact-form-section");
  var data_error = submission_data.getAttribute("data-error");
  var data_recaptcha_error = submission_data.getAttribute(
    "data-recaptcha-error"
  );

  const recaptcha_errors = [
    "missing-input-secret",
    "invalid-input-secret",
    "missing-input-response",
    "invalid-input-response",
    "bad-request",
    "timeout-or-duplicate",
  ];

  $.ajax({
    headers: {
      "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
    },
    type: "POST",
    url: "contact-form",
    data: formData,
    processData: false,
    contentType: false,
    success: function (msg) {
      $("#contact-form")[0].reset();
      $(".g-recaptcha").remove();
      $("#contact-form-section :input").prop("disabled", true);
      $("#contact-form-result").html(msg);
    },
    error: function (xhr) {
      $.each(xhr.responseJSON.errors, function (key, value) {
        if (recaptcha_errors.indexOf(value) > -1) {
          grecaptcha.reset();
          $("#contact-form-result").html(
            '<div class="alert alert-danger show" role="alert"><b>' +
              data_error +
              ":</b> " +
              data_recaptcha_error +
              "</div"
          );
          return false;
        }

        $("#contact-form-result").html(
          '<div class="alert alert-danger show" role="alert"><b>' +
            data_error +
            ":</b> " +
            value +
            "</div"
        );
        return false;
      });
    },
  });
}

// ReadMoreJS
/**
 * @app ReadMoreJS
 * @desc Breaks the content of an element to the specified number of words
 * @version 1.1.0
 * @license The MIT License (MIT)
 * @author George Raptis | http://georap.gr
 */
(function (win, doc, undef) {
  "use strict";

  var RM = {};

  RM.helpers = {
    extendObj: function () {
      for (var i = 1, l = arguments.length; i < l; i++) {
        for (var key in arguments[i]) {
          if (arguments[i].hasOwnProperty(key)) {
            if (
              arguments[i][key] &&
              arguments[i][key].constructor &&
              arguments[i][key].constructor === Object
            ) {
              arguments[0][key] = arguments[0][key] || {};
              this.extendObj(arguments[0][key], arguments[i][key]);
            } else {
              arguments[0][key] = arguments[i][key];
            }
          }
        }
      }
      return arguments[0];
    },
  };

  RM.countWords = function (str) {
    return str.split(/\s+/).length;
  };

  RM.generateTrimmed = function (str, wordsNum) {
    return str.split(/\s+/).slice(0, wordsNum).join(" ") + "...";
  };

  RM.init = function (options) {
    var defaults = {
      target: "",
      numOfWords: 50,
      toggle: true,
      moreLink: "read more...",
      lessLink: "read less",
      linkClass: "rm-link",
      containerClass: false,
    };
    options = RM.helpers.extendObj({}, defaults, options);

    var target = doc.querySelectorAll(options.target),
      targetLen = target.length,
      targetContent,
      trimmedTargetContent,
      targetContentWords,
      initArr = [],
      trimmedArr = [],
      i,
      j,
      l,
      moreContainer,
      rmLink,
      moreLinkID,
      index;

    for (i = 0; i < targetLen; i++) {
      targetContent = target[i].innerHTML;
      trimmedTargetContent = RM.generateTrimmed(
        targetContent,
        options.numOfWords
      );
      targetContentWords = RM.countWords(targetContent);

      initArr.push(targetContent);
      trimmedArr.push(trimmedTargetContent);

      if (options.numOfWords < targetContentWords - 1) {
        target[i].innerHTML = trimmedArr[i];

        moreContainer = doc.createElement("div");
        if (options.containerClass) {
          moreContainer.className = options.containerClass;
        }

        moreContainer.innerHTML =
          '<a id="rm-more_' +
          i +
          '"' +
          ' class="' +
          options.linkClass +
          '"' +
          ' style="cursor:pointer;" data-readmore="anchor">' +
          options.moreLink +
          "</a>";
        target[i].parentNode.insertBefore(moreContainer, target[i].nextSibling);
      }
    }

    rmLink = doc.querySelectorAll('[data-readmore="anchor"]');

    for (j = 0, l = rmLink.length; j < l; j++) {
      rmLink[j].onclick = function () {
        moreLinkID = this.getAttribute("id");
        index = moreLinkID.split("_")[1];

        if (this.getAttribute("data-clicked") !== "true") {
          target[index].innerHTML = initArr[index];
          if (options.toggle !== false) {
            this.innerHTML = options.lessLink;
            this.setAttribute("data-clicked", true);
          } else {
            this.innerHTML = "";
          }
        } else {
          target[index].innerHTML = trimmedArr[index];
          this.innerHTML = options.moreLink;
          this.setAttribute("data-clicked", false);
        }
      };
    }
  };

  window.$readMoreJS = RM;
})(this, this.document);

// Infinite Scroll
$(document).ready(function () {
  "use strict";

  if (document.getElementById("infinite-scroll")) {
    $(".infinite-scroll").infiniteScroll({
      path: ".pagination__next",
      append: ".other-links",
      history: false,
      hideNav: ".pagination-next",
      status: ".page-load-status",
    });
  }
});

// Search Links
$(document).on("keydown", "#search-form", function (e) {
  var id = this.id;
  var base_url = document
    .querySelector("meta[property='base_url']")
    .getAttribute("content");
  var search_url = base_url + "/" + "json-search";

  $("#" + id).autocomplete({
    source: function (request, response) {
      $.ajax({
        headers: {
          "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        url: search_url,
        type: "post",
        dataType: "json",
        data: {
          list_id: "a",
          search: request.term,
          request: 1,
        },
        success: function (data) {
          response(data);
        },
      });
    },
    select: function (event, ui) {
      window.location.href = ui.item.site_url;
      return false;
    },
    open: function () {
      $("ul.ui-menu").width($(this).innerWidth());
    },
    create: function (event, ui) {
      $(this).data("ui-autocomplete")._renderItem = function (ul, item) {
        var rich_html =
          '<div class="d-flex flex-row"><div><img src=\'' +
          item.image +
          '\' class="site-icon rounded" /></div><div class="my-auto"><strong>' +
          item.title +
          '</strong>' + item.votes + '<span class="site-url">' +
          item.url +
          "</span></span></div></div>";
        return $("<li></li>")
          .data("item.autocomplete", item)
          .append(rich_html)
          .appendTo(ul);
      };
    },
  });
});


