// Lazy Load
$(document).ready(function () {
  "use strict";

  $(".lazy").Lazy({
    scrollDirection: "vertical",
    effect: "fadeIn",
    visibleOnly: true,
    onError: function (element) {
      console.log("error loading " + element.data("src"));
    },
  });
});

// Tooltips
$(function () {
  "use strict";
  if (document.getElementsByClassName("title-badge")) {
  var tooltipTriggerList = [].slice.call(
    document.querySelectorAll('[data-bs-toggle="tooltip"]')
  );
  var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
    return new bootstrap.Tooltip(tooltipTriggerEl);
  });
  }
});

// Show more/less content
$(document).ready(function () {
  "use strict";

  if (document.getElementById("description")) {
    var pagination_data = document.getElementById("description");
    var show_more = pagination_data.getAttribute("data-show-more");
    var show_less = pagination_data.getAttribute("data-show-less");

    $readMoreJS.init({
      target: ".description",
      numOfWords: 75,
      toggle: true,
      moreLink: show_more,
      lessLink: show_less,
    });
  }
});

// Show more/less reviews
$(document).ready(function () {
  "use strict";

  if (document.getElementById("review-title")) {
    var pagination_data = document.getElementById("review-title");
    var show_more = pagination_data.getAttribute("data-show-more");
    var show_less = pagination_data.getAttribute("data-show-less");

    if ($(".review").length > 3) {
      $(".review:gt(2)").hide();
      $(".show-more").show();
    }

    $(".show-more").on("click", function () {
      "use strict";

      $(".review:gt(2)").toggle();
      $(this).text() === show_less
        ? $(this).text(show_more)
        : $(this).text(show_less);
    });
  }
});

// Rating Function
(function (a, d) {
  "use strict";
  a.fn.rating = function (b) {
    b = b || function () {};
    this.each(function (d, c) {
      a(c)
        .data("rating", {
          callback: b,
        })
        .bind("init.rating", a.fn.rating.init)
        .bind("set.rating", a.fn.rating.set)
        .bind("hover.rating", a.fn.rating.hover)
        .trigger("init.rating");
    });
  };
  a.extend(a.fn.rating, {
    init: function (h) {
      var d = a(this),
        g = "",
        j = null,
        f = d.children(),
        c = 0,
        b = f.length;
      for (; c < b; c++) {
        g = g + '<a class="star" title="' + a(f[c]).val() + '" />';
        if (a(f[c]).is(":checked")) {
          j = a(f[c]).val();
        }
      }
      f.hide();
      d.append('<div class="stars">' + g + "</div>").trigger("set.rating", j);
      a("a", d).bind("click", a.fn.rating.click);
      d.trigger("hover.rating");
    },
    set: function (f, g) {
      var c = a(this),
        d = a("a", c),
        b = undefined;
      if (g) {
        d.removeClass("fullStar");
        b = d.filter(function (e) {
          if (a(this).attr("title") == g) {
            return a(this);
          } else {
            return false;
          }
        });
        b.addClass("fullStar").prevAll().addClass("fullStar");
      }
      return;
    },
    hover: function (d) {
      var c = a(this),
        b = a("a", c);
      b.bind("mouseenter", function (f) {
        a(this).addClass("tmp_fs").prevAll().addClass("tmp_fs");
        a(this).nextAll().addClass("tmp_es");
      });
      b.bind("mouseleave", function (f) {
        a(this).removeClass("tmp_fs").prevAll().removeClass("tmp_fs");
        a(this).nextAll().removeClass("tmp_es");
      });
    },
    click: function (g) {
      g.preventDefault();

      var f = a(g.target),
        c = f.parent().parent(),
        b = c.children("input"),
        d = f.attr("title");
      var matchInput = b.filter(function (e) {
        if (a(this).val() == d) {
          return true;
        } else {
          return false;
        }
      });
      matchInput.attr("checked", true);
      var sort_type = document.getElementsByClassName("ratings")[0].id;

      var rating_data = document.getElementById("rating");
      var sort_type = rating_data.getAttribute("data-rating-id");

      c.trigger("set.rating", matchInput.val())
        .data("rating")
        .callback(d, g, sort_type);
    },
  });
})(jQuery);

// SimpleLightbox
$(function() {
    "use strict";

    if (document.getElementById("gallery")) {
        $('#gallery a').simpleLightbox();
    }
});

// Show progress bar using data attributes
$(document).ready(function () {
  "use strict";

  $(".progress > div").css("width", function () {
    return $(this).parent().data("bar-width") + "%";
  });
});

// Openlayers Map Functions
$(document).ready(function () {
  "use strict";

if (document.getElementById("map")) {

var map_data = document.getElementById("map");
var map_title = map_data.getAttribute("data-title");
var map_lat = parseFloat(map_data.getAttribute("data-lat"));
var map_lon = parseFloat(map_data.getAttribute("data-lon"));
var map_zoom = parseFloat(map_data.getAttribute("data-zoom"));

var attribution = new ol.control.Attribution({
  collapsible: false
});

var map = new ol.Map({
  controls: ol.control.defaults({
      attribution: false
  }).extend([attribution])
  , layers: [
      new ol.layer.Tile({
          source: new ol.source.OSM({
              url: 'https://tile.openstreetmap.org/{z}/{x}/{y}.png'
              , maxZoom: 18
          })
      })
  ]
  , target: 'map'
  , view: new ol.View({
      center: ol.proj.fromLonLat([map_lon, map_lat])
      , maxZoom: 18
      , zoom: map_zoom
  , })
});
map.on('click', e => {
  var point = map.getCoordinateFromPixel(e.pixel);
  var lonLat = ol.proj.toLonLat(point);
  console.log(lonLat);

})

var layer = new ol.layer.Vector({
  source: new ol.source.Vector({
      features: [
          new ol.Feature({
              geometry: new ol.geom.Point(ol.proj.fromLonLat([map_lon, map_lat]))
          })
      ]
  })
});

map.addLayer(layer);

var container = document.getElementById('popup');
var content = document.getElementById('popup-content');

var overlay = new ol.Overlay({
  element: container
  , autoPan: true
  , autoPanAnimation: {
      duration: 250
  }
});
map.addOverlay(overlay);

content.innerHTML = map_title;
overlay.setPosition(ol.proj.fromLonLat([map_lon, map_lat]));

}
});