<?php
namespace App\Http\Controllers;

use App;
use App\Mail\Ordercomplete;
use App\Mail\Packagedisabled;
use App\Mail\Packagerenewed;
use App\Mail\Paymentreminder;
use App\Mail\Submissionreceived;
use App\Models\Category;
use App\Models\Package;
use Carbon\Carbon;
use File;
use Illuminate\Support\Facades\DB;
use Intervention\Image\ImageManagerStatic as Image;

class CronjobController extends Controller
{
    public function __construct()
    {
        // Site Settings
        $site_settings = DB::table('settings')->get();

        foreach ($site_settings as $setting) {
            $setting_name = $setting->name;
            $this->$setting_name = $setting->value;
            if ($setting->language == null) {
                $settings[$setting->name] = $setting->value;
            } else {
                $settings[$setting->name . '-' . $setting->language] = $setting->value;
            }
        }

        // Languages
        $this->languages = DB::table('translations')->OrderBy('sort', 'ASC')->get();

        foreach ($this->languages as $language) {
            if ($language->code == $settings['site_language']) {
                $this->site_language_id = $language->id;
            }
            if ($settings['root_language'] == '1' && $language->code == $settings['site_language']) {
                $this->language_prefix[$language->id] = '/';
            } else {
                $this->language_prefix[$language->id] = $language->code . '/';
            }
        }

        // List of packages
        $this->packages = Package::get();

        // List of categories in footer
        $this->categories = Category::get();

        $this->mail_site_title = $settings['site_title' . '-' . $this->site_language_id];
        $this->mail_from = $_ENV['MAIL_FROM_ADDRESS'];
    }

    /** Index */
    public function index()
    {
        $slug = request()->slug;

        // Return 404 page if cronjob code is not correct
        if ($this->cronjob_code != $slug) {
            abort(404);
        }

        $now = Carbon::now();

        /* PayPal Webhook Verifier */
        $webhook_verifier = DB::table('paypal_webhook_calls')->where('processed', '0')->orderBy('id', 'ASC')->get();

        foreach ($webhook_verifier as $webhook) {

            $webhook_data = $webhook->payload;
            $webhook_data = json_decode($webhook_data);

            // Package Durations
            $durations = submission_durations();

            if ($webhook_data->event_type == 'PAYMENT.SALE.COMPLETED') {

                $order_query = DB::table('orders')
                    ->leftJoin('packages', 'orders.package', '=', 'packages.id')
                    ->leftJoin('users', 'orders.user', '=', 'users.id')
                    ->leftJoin('submissions', 'orders.submission_id', '=', 'submissions.id')
                    ->select('packages.duration AS duration', 'users.name AS link_name', 'users.email AS link_email', 'submissions.url AS url', 'submissions.category AS category', 'submissions.title AS title', 'submissions.description AS description', 'submissions.ip AS ip', 'orders.*')
                    ->where('subscription_id', $webhook_data->resource->billing_agreement_id)
                    ->orderBy('id', 'ASC')
                    ->first();

                if ($order_query->payment_status == '2' && $order_query->status == '0') {
                    DB::table('orders')->where('id', $order_query->id)->update(['payment_status' => '1', 'status' => '1', 'created_at' => $now, 'payment_id' => $webhook_data->id]);

                    // Package Details
                    $package = DB::table('packages')->where('id', $order_query->package)->first();

                    foreach ($this->packages as $package) {
                        $package_name[$package->id] = $package->title;
                    }

                    foreach ($this->categories as $category) {
                        $category_name[$category->id] = $category->title;
                    }

                    // Notify link owner by email
                    \Mail::to($order_query->link_email)->send(new Ordercomplete($durations[$order_query->duration], $this->payment_currency_symbol . $order_query->price, $package->title, $order_query->url, $this->mail_site_title, $this->mail_from));

                    // Notify site owner by email
                    if ($this->submission_notification_mail == '1') {
                        \Mail::to($this->admin_email)->send(new Submissionreceived($order_query->link_name, $order_query->link_email, $package_name[$order_query->package], $this->mail_site_title, $order_query->url, $order_query->title, $order_query->description, $category_name[$order_query->category], $order_query->ip, $this->mail_from));
                    }

                    // Insert Notification Record
                    insert_notification('3', $this->payment_currency_symbol . $order_query->price);
                    insert_notification('2', $order_query->url);
                }

                $payment_id_check = DB::table('orders')->where('payment_id', $webhook_data->id)->count('id');

                if ($payment_id_check == '0') {

                    // Insert Order Record
                    $last_order_id = DB::table('orders')->insertGetId(array(
                        'submission_id' => $order_query->submission_id,
                        'payment_id' => $webhook_data->id,
                        'payment_method' => '5',
                        'subscription_id' => $webhook_data->resource->billing_agreement_id,
                        'package' => $order_query->package,
                        'price' => $webhook_data->resource->amount->total,
                        'currency_symbol' => $order_query->currency_symbol,
                        'payment_status' => 1,
                        'is_renewal' => 1,
                        'link_id' => $order_query->link_id,
                        'user' => $order_query->user,
                        'created_at' => \Carbon\Carbon::now()->toDateTimeString(),
                    ));

                    if ($order_query->link_id == null) {
                        // Insert Notification Record
                        insert_notification('5', $this->payment_currency_symbol . $order_query->price);

                    } else {
                        // Insert Notification Record
                        insert_notification('5', $this->payment_currency_symbol . $order_query->price);
                        insert_notification('4', $order_query->url);

                        $link_query = DB::table('links')->where('id', $order_query->link_id)->first();

                        if ($now > $link_query->expire_at) {
                            $new_expire_time = expire_time($order_query->duration, $now);
                            DB::table('links')->where('id', $link_query->id)->update(['enabled' => '1', 'status' => '2']);
                        } else {
                            $new_expire_time = expire_time($order_query->duration, $link_query->expire_at);
                        }

                        DB::table('links')->where('id', $link_query->id)->update(['expire_at' => $new_expire_time]);

                        // Package Details
                        $package = DB::table('packages')->where('id', $link_query->package)->first();

                        // Notify link owner by email
                        \Mail::to($order_query->link_email)->send(new Packagerenewed($durations[$order_query->duration], $this->payment_currency_symbol . $order_query->price, $package->title, $link_query->url, $this->mail_site_title, $this->mail_from));
                    }

                }

            }

            DB::table('paypal_webhook_calls')->where('id', $webhook->id)->update(['processed' => 1]);

        }

        /* Screenshot Queue */
        // Pending screenshot Requests
        $screenshots = DB::table('screenshot_queue')->get();

        // Download Screenshot
        foreach ($screenshots as $screenshot) {

            $detail = DB::table('links')->where('id', $screenshot->link_id)->first();

            if ($detail == null) {
                DB::table('screenshot_queue')->where('id', '=', $screenshot->id)->delete();
                continue;
            } else {

                $image_url = "https://image.thum.io/get/auth/$this->thum_io_id-$this->thum_io_url_key/$detail->url";

                if ($this->save_as_webp == '1') {
                    $file_name = time() . rand(11111, 99999) . '.webp';
                } else {
                    $file_name = time() . rand(11111, 99999) . '.png';
                }

                $time_difference = strtotime(date("Y-m-d H:i:s")) - strtotime($screenshot->created_at);

                // Save screenshot if 45 seconds have passed
                if ($time_difference >= 45) {
                    if ($this->save_screenshot_as_icon == '1' || $screenshot->as_icon == '1') {
                        $location = public_path('images/links/' . $file_name);
                        Image::make($image_url)->resize(200, 200)->save($location, $this->image_quality);
                        DB::table('links')->where('id', $detail->id)->update(['image' => $file_name]);
                        DB::table('screenshot_queue')->where('link_id', '=', $screenshot->link_id)->delete();

                        if ($detail->image != null) {
                            if (file_exists(public_path() . '/images/links/' . $detail->image)) {
                                $old_image = public_path('images/links/' . $detail->image);
                                File::delete($old_image);
                            }
                        }
                    }

                    if ($screenshot->as_icon == '0') {
                        $location = public_path('images/screenshots/' . $file_name);
                        Image::make($image_url)->resize(600, 600)->save($location, $this->image_quality);
                        DB::table('links')->where('id', $detail->id)->update(['screenshot' => $file_name]);
                        DB::table('screenshot_queue')->where('link_id', '=', $screenshot->link_id)->delete();

                        if ($detail->screenshot != null) {
                            if (file_exists(public_path() . '/images/screenshots/' . $detail->screenshot)) {
                                $old_image = public_path('images/screenshots/' . $detail->screenshot);
                                File::delete($old_image);
                            }
                        }
                    }
                }
            }
        }

        /* Send Payment Notifications */
        $durations = submission_durations();

        if ($this->send_expire_notification == '1') {

            $date = Carbon::now()->addDays(1);

            $links = DB::table('links')
                ->leftJoin('packages', 'links.package', '=', 'packages.id')
                ->leftJoin('users', 'links.owner', '=', 'users.id')
                ->select('packages.duration AS duration', 'packages.title AS package_name', 'packages.duration AS duration', 'packages.price AS price', 'users.email AS user_email', 'links.*')
                ->where('expire_at', '<', $date)
                ->where('owner', '!=', '1')
                ->where('status', '2')
                ->get();

            foreach ($links as $link) {

                if ($link->is_subscription == 0 && $link->price != '0.00') {

                    $time_difference_expire = $now->diffInHours($link->expire_at);

                    // Send notification if daily package and 12 hours left
                    if ($time_difference_expire <= 12 && $link->duration == '1') {
                        $check_notification = DB::table('expire_notifications')->where('link_id', $link->id)->orderby('id', 'desc')->first();
                        if (!isset($check_notification)) {

                            // Notify site owner by email
                            \Mail::to($link->user_email)->send(new Paymentreminder(12, \Carbon\Carbon::parse($link->expire_at)->translatedFormat('F d, Y H:i:s'), $durations[$link->duration], $this->payment_currency_symbol . $link->price, $link->package_name, $link->url, asset($this->language_prefix[$this->language_id] . 'member-area/my-links'), $this->mail_site_title, $this->mail_from));

                            DB::table('expire_notifications')->insert(
                                [
                                    'link_id' => $link->id,
                                    'sent_at' => date("Y-m-d H:i:s"),
                                    'created_at' => date("Y-m-d H:i:s"),
                                ]
                            );

                        }
                    }

                    // Send notification if daily package and 24 hours left
                    if ($time_difference_expire <= 24 && $link->duration != '1') {
                        $check_notification = DB::table('expire_notifications')->where('link_id', $link->id)->orderby('id', 'desc')->first();
                        if (!isset($check_notification)) {

                            // Notify site owner by email
                            \Mail::to($link->user_email)->send(new Paymentreminder(24, \Carbon\Carbon::parse($link->expire_at)->translatedFormat('F d, Y H:i:s'), $durations[$link->duration], $this->payment_currency_symbol . $link->price, $link->package_name, $link->url, asset($this->language_prefix[$this->language_id] . 'member-area/my-links'), $this->mail_site_title, $this->mail_from));

                            DB::table('expire_notifications')->insert(
                                [
                                    'link_id' => $link->id,
                                    'sent_at' => date("Y-m-d H:i:s"),
                                    'created_at' => date("Y-m-d H:i:s"),
                                ]
                            );

                        }
                    }

                }
            }
        }

        /* Check Expired Links */
        $expired_links = DB::table('links')
            ->leftJoin('packages', 'links.package', '=', 'packages.id')
            ->leftJoin('users', 'links.owner', '=', 'users.id')
            ->select('packages.duration AS duration', 'packages.title AS package_name', 'packages.duration AS duration', 'packages.price AS price', 'users.email AS user_email', 'links.*')
            ->whereRaw("expire_at < '$now' AND enabled='1'")
            ->get();

        foreach ($expired_links as $link) {

            // Grace period calculation
            $grace_period = date('Y-m-d H:i:s', strtotime("$link->expire_at + $this->grace_period hours"));

            // Check if link is in grace period
            if ($now > $link->expire_at && $link->status == '2' && $now < $grace_period) {
                DB::table('links')->where('id', $link->id)->update(['status' => '4']);
            }

            // Check if link is expired
            if ($now > $grace_period) {
                DB::table('links')->where('id', $link->id)->update(['enabled' => '0', 'status' => '5']);

                // Notify site owner by email
                \Mail::to($link->user_email)->send(new Packagedisabled($durations[$link->duration], $this->payment_currency_symbol . $link->price, $link->package_name, $link->url, asset($this->language_prefix[$this->site_language_id] . 'member-area/my-links'), $this->mail_site_title, $this->mail_from));

            }

            // Send mail

        }

        echo "OK";

    }

}
