<?php

namespace App\Http\Middleware;

use Closure;

class AdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if(env('ADMIN_IP_ADDRESS') != '' && env('ADMIN_IP_ADDRESS') != \Request::ip()) {
            abort(404);
        }

        if (\Auth::check() && \Auth::user()->user_type == '1') {
            return $next($request);
        }
        
        \Auth::logout(); // log the user out
        return \Redirect::to(env('ADMIN_LOGIN_URL'))->withErrors(__('general.not_authorized'));
    }
}
