<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class Newpassword extends Mailable
{
    use Queueable, SerializesModels;

    public $login_link;
    public $new_password;
    public $site_title;
    public $mail_from;

    /**
     * Create a new message instance.
     *
     * @return void
     */
     public function __construct($new_password, $login_link, $site_title, $mail_from)
    {
        $this->login_link = $login_link;
        $this->new_password = $new_password;
        $this->mail_from = $mail_from;
        $this->site_title = $site_title;

        }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from($this->mail_from)->markdown('vendor.frontend.mail.newpassword')->subject(__('general.your_new_password'));
    }
}
