<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class Packagedisabled extends Mailable
{
    use Queueable, SerializesModels;

    public $billing_cycle;
    public $price;
    public $package;
    public $url;
    public $renewal_page;
    public $site_title;
    public $mail_from;
    
    /**
     * Create a new message instance.
     *
     * @return void
     */
     public function __construct($billing_cycle, $price, $package, $url, $renewal_page, $site_title, $mail_from)
    {
        $this->billing_cycle = $billing_cycle;
        $this->price = $price;
        $this->package = $package;
        $this->url = $url;
        $this->renewal_page = $renewal_page;
        $this->site_title = $site_title;
        $this->mail_from = $mail_from;

        }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from($this->mail_from)->markdown('vendor.frontend.mail.package_disabled')->subject(__('general.your_package_has_been_disabled'));
    }
}
