<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class Paymentreminder extends Mailable
{
    use Queueable, SerializesModels;

    public $remaining_time;
    public $expire_date;
    public $billing_cycle;
    public $price;
    public $package;
    public $url;
    public $renewal_page;
    public $site_title;
    public $mail_from;

    /**
     * Create a new message instance.
     *
     * @return void
     */
     public function __construct($remaining_time, $expire_date, $billing_cycle, $price, $package, $url, $renewal_page, $site_title, $mail_from)
    {
        $this->remaining_time = $remaining_time;
        $this->expire_date = $expire_date;
        $this->billing_cycle = $billing_cycle;
        $this->price = $price;
        $this->package = $package;
        $this->url = $url;
        $this->renewal_page = $renewal_page;
        $this->site_title = $site_title;
        $this->mail_from = $mail_from;

        }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from($this->mail_from)->markdown('vendor.frontend.mail.payment_reminder')->subject(__('general.package_expires_in', ['remaining_time' => $this->remaining_time]));
    }
}
