<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class Submissionapproved extends Mailable
{
    use Queueable, SerializesModels;

    public $mail_from;
    public $site_title;
    public $url;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($url, $site_title, $mail_from)
    {
        $this->url = $url;
        $this->mail_from = $mail_from;
        $this->site_title = $site_title;
        }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from($this->mail_from)->markdown('vendor.frontend.mail.submission_approved')->subject(__('general.submission_approved'));
    }
}
