@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.create_bank_account'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- form -->
            <form method="POST" enctype="multipart/form-data" action="{{url(env('ADMIN_URL').'/bank_accounts')}}">
                @csrf @method('POST')

                <!-- box-body -->
                <div class="box-body">

                    <div class="form-group">
                        <label>@lang('admin.bank_name') <span class="text-danger">*</span></label>
                        <input type="text" name="bank_name" value="{{old('bank_name')}}" class="form-control" placeholder="@lang('admin.bank_name')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.account_details') <span class="text-danger">*</span></label>
                        <textarea class="textarea textarea-style" name="details" placeholder="@lang('admin.account_details')">{{old('details')}}</textarea>
                    </div>

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('admin.enabled')</label><br />
                                <input type="checkbox" name="enabled" @if(!old() || old('enabled')=='on' ) checked="checked" @endif>
                            </div>
                        </div>

                    </div>
                    <!-- row -->

                </div>
                <!-- /.box-body -->

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">@lang('admin.submit')</button>
                </div>

            </form>
            <!-- /.form -->

        </div>
        <!-- /.general form elements -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection