@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.notifications'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- box-body -->
            <div class="box-body no-padding">

                <div class="table-responsive">
                    <table class="table table-striped" id="table">
                        <tr>
                            <th class="col-md-1">ID</th>
                            <th class="col-md-9">@lang('admin.action')</th>
                            <th class="col-md-2">@lang('admin.date')</th>
                        </tr>
                        <tbody>
                            @foreach($notifications_list as $row)
                            <tr>
                                <td>{{$row->id}}</td>
                                <td>{{notification_types($row->action)}} - {{$row->details}}</td>
                                <td>{{\Carbon\Carbon::parse($row->created_at)->translatedFormat('M d, Y H:i:s')}}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

            </div>
            <!-- /.box-body -->

        </div>
        <!-- /.general form elements -->

        @if($notifications_list->isEmpty())
        <h6 class="alert alert-danger">@lang('admin.no_record').</h6>
        @endif

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

{{ $notifications_list->links()}}

@endsection