@if (!empty($ad[2]))<div class="container text-center mb-3">{!! $ad[2] !!}</div>@endif

<div class="footer-container">

    <footer class="page-footer">

        <div class="container">

            <div class="row">

                <div class="col-md-3 mx-auto">
                    @if ($settings['use_text_logo'] == '0')
                    <img src="{{ asset('/images/logo.png') }}" class="footer-logo" alt="{{$settings['site_title']}}"><br />
                    @else
                    <span class="footer-text-logo">{{$settings['site_title']}}</span>
                    @endif
                    {{$settings['site_description']}}
                    
                    <div class="clearfix mt-3"></div>
                    
                    @if (!empty($settings['facebook_page']))<a href="{{$settings['facebook_page']}}" target="_blank"><i class="icon-facebook mt-3"></i></a>@endif
                    @if (!empty($settings['twitter_account']))<a href="https://www.twitter.com/{{$settings['twitter_account']}}" target="_blank"><i class="icon-twitter mt-3"></i></a>@endif
                    @if (!empty($settings['telegram_page']))<a href="{{$settings['telegram_page']}}" target="_blank"><i class="icon-paper-plane mt-3"></i></a>@endif
                </div>

                <div class="clearfix w-100 d-md-none">&nbsp;</div>

                <div class="col-md-3 col-4">
                    <span class="section-head">@lang('general.pages')</span><br /><br />
                    <ul class="list-unstyled">
                        @foreach ($pages as $page)
                        @if ($page->footer == '1')
                        <li><a href="{{ asset($language_prefix.$settings['page_base']) }}/{{ $page->slug }}">{{ $page->title }}</a></li>
                        @endif
                        @endforeach
                        <li><a href="{{ asset($language_prefix.$settings['contact_slug']) }}">@lang('general.contact')</a></li>
                    </ul>
                </div>

                <div class="col-md-3 col-4">
                    <span class="section-head">@lang('general.categories')</span><br /><br />
                    <ul class="list-unstyled">
                        @foreach ($categories as $category)
                        @if ($category->footer == '1')
                        <li><a href="{{ asset($language_prefix.$settings['category_base']) }}/@if ($category->parent_id == '0')@else{{ $category_slug[$category->parent_id] }}/@endif{{ $category->slug }}">{{ $category->title }}</a></li>
                        @endif
                        @endforeach
                    </ul>
                </div>

                <div class="col-md-3 col-4">
                    <span class="section-head mt-3 mb-4">@lang('general.partners_friends')</span><br /><br />
                    <ul class="list-unstyled">
                        @foreach ($partners as $partner)
                        @if ($partner->footer == '1')
                        <li><a href="{{ $partner->url }}" target="_blank" {!! $link_types[$partner['link_type']] !!}>{{ $partner->title }}</a></li>
                        @endif
                        @endforeach
                    </ul>
                </div>

            </div>

        </div>

        <div class="footer-copyright text-center py-2">© {{date('Y')}} @lang('general.copyright_notice') - <a href="{{ asset('') }}"> {{$settings['site_title']}}</a></div>

    </footer>

</div>

@if ($settings['show_cookie_bar'] == '1')
<!-- Cookie Alert -->
<div class="p-2 text-center cookiealert" role="alert">
    @lang('general.cookies_note')
    <button type="button" class="btn btn-sm acceptcookies" aria-label="Close">
        @lang('general.accept_cookies')
    </button>
</div>
<!-- /Cookie Alert -->
@endif

{!!$settings['before_body_end_tag']!!}

@stack('assets_footer')

<!-- Popper -->
<script src="{{ asset('js/popper.min.js') }}"></script>

@if (!\Request::is("*member-area/package/*", "*member-area/edit/*"))
<!-- Bootstrap -->
<script src="{{ asset('js/bootstrap.min.js') }}"></script>
@endif

<!-- simpleLightbox -->
<script src="{{ asset('js/simpleLightbox.min.js') }}"></script>

<!-- Other JS -->
<script src="{{ asset('js/scripts.js') }}"></script>

@if ($settings['enable_live_ajax_search'] == '1')
<!-- jQuery UI -->
<script defer async src="{{ asset('js/jquery-ui.js') }}"></script>
@endif

@if ($settings['show_cookie_bar'] == '1')
<!-- Cookie Alert -->
<script src="{{ asset('js/cookiealert.js') }}"></script>
@endif